/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.server.memcached.InterceptorChain;
import org.infinispan.server.memcached.commands.CasCommand;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.DeleteCommand;
import org.infinispan.server.memcached.commands.FlushAllCommand;
import org.infinispan.server.memcached.commands.NumericCommand;
import org.infinispan.server.memcached.commands.QuitCommand;
import org.infinispan.server.memcached.commands.RetrievalCommand;
import org.infinispan.server.memcached.commands.RetrievalParameters;
import org.infinispan.server.memcached.commands.StatsCommand;
import org.infinispan.server.memcached.commands.StorageCommand;
import org.infinispan.server.memcached.commands.StorageParameters;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.server.memcached.commands.VersionCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.util.NotImplementedException;

public class CommandFactory {
    private static final Log log = LogFactory.getLog(CommandFactory.class);
    private static final String NO_REPLY = "noreply";
    private final Cache<String, Value> cache;
    private final InterceptorChain chain;
    private final ScheduledExecutorService scheduler;

    public CommandFactory(Cache<String, Value> cache, InterceptorChain chain, ScheduledExecutorService scheduler) {
        this.cache = cache;
        this.chain = chain;
        this.scheduler = scheduler;
    }

    public TextCommand createCommand(String line) throws IOException {
        String[] args;
        String tmp;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Command line: " + line));
        }
        if ((tmp = (args = line.trim().split(" +"))[0]) == null) {
            throw new EOFException();
        }
        CommandType type = CommandType.parseType(tmp);
        switch (type) {
            case SET: 
            case ADD: 
            case REPLACE: 
            case APPEND: 
            case PREPEND: {
                return StorageCommand.newStorageCommand(this.cache, type, this.getStorageParameters(args), null, this.parseNoReply(5, args));
            }
            case CAS: {
                tmp = args[5];
                long cas = Long.parseLong(tmp);
                return CasCommand.newCasCommand(this.cache, this.getStorageParameters(args), cas, null, this.parseNoReply(6, args));
            }
            case GET: 
            case GETS: {
                ArrayList<String> keys = new ArrayList<String>(5);
                keys.addAll(Arrays.asList(args).subList(1, args.length));
                return RetrievalCommand.newRetrievalCommand(this.cache, type, new RetrievalParameters(keys));
            }
            case DELETE: {
                String delKey = this.getKey(args[1]);
                int time = this.parseDelayedDeleteTime(2, args);
                boolean noReply = false;
                if (time == -1) {
                    noReply = this.parseNoReply(2, args);
                }
                return DeleteCommand.newDeleteCommand(this.cache, delKey, noReply);
            }
            case INCR: 
            case DECR: {
                String key = this.getKey(args[1]);
                String delta = args[2];
                return NumericCommand.newNumericCommand(this.cache, type, key, delta, this.parseNoReply(3, args));
            }
            case STATS: {
                return StatsCommand.newStatsCommand(this.cache, type, this.chain);
            }
            case FLUSH_ALL: {
                long delay = args.length > 1 ? Long.parseLong(args[1]) : 0L;
                return FlushAllCommand.newFlushAllCommand(this.cache, delay, this.scheduler, this.parseNoReply(2, args));
            }
            case VERSION: {
                return VersionCommand.newVersionCommand();
            }
            case QUIT: {
                return QuitCommand.newQuitCommand();
            }
        }
        throw new NotImplementedException("Parsed type not implemented yet");
    }

    private StorageParameters getStorageParameters(String[] args) throws IOException {
        return new StorageParameters(this.getKey(args[1]), this.getFlags(args[2]), this.getExpiry(args[3]), this.getBytes(args[4]));
    }

    private String getKey(String key) throws IOException {
        if (key == null) {
            throw new EOFException("No key passed");
        }
        return key;
    }

    private int getFlags(String flags) throws IOException {
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        return Integer.parseInt(flags);
    }

    private long getExpiry(String expiry) throws IOException {
        if (expiry == null) {
            throw new EOFException("No expiry passed");
        }
        return Long.parseLong(expiry);
    }

    private int getBytes(String bytes) throws IOException {
        if (bytes == null) {
            throw new EOFException("No bytes for storage command passed");
        }
        return Integer.parseInt(bytes);
    }

    private boolean parseNoReply(int expectedIndex, String[] args) throws IOException {
        if (args.length > expectedIndex) {
            if (NO_REPLY.equals(args[expectedIndex])) {
                return true;
            }
            throw new StreamCorruptedException("Unable to parse noreply optional argument");
        }
        return false;
    }

    private int parseDelayedDeleteTime(int expectedIndex, String[] args) {
        if (args.length > expectedIndex) {
            try {
                return Integer.parseInt(args[expectedIndex]);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }
}

