/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Command;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.SetCommand;
import org.infinispan.server.memcached.commands.StorageParameters;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;

public class CasCommand
extends SetCommand {
    final long cas;

    CasCommand(Cache cache, CommandType type, StorageParameters params, long cas, byte[] data, boolean noReply) {
        super((Cache<String, Value>)cache, type, params, data, noReply);
        this.cas = cas;
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitCas(ctx, this);
    }

    @Override
    public Command setData(byte[] data) throws IOException {
        return CasCommand.newCasCommand(this.cache, this.params, this.cas, data, this.noReply);
    }

    @Override
    protected Reply put(String key, int flags, byte[] data, long expiry) {
        Value old = (Value)this.cache.get((Object)key);
        if (old != null) {
            if (old.getCas() == this.cas) {
                Value value = new Value(flags, data, old.getCas() + 1L);
                boolean replaced = this.cache.replace((Object)key, (Object)old, (Object)value);
                if (replaced) {
                    return Reply.STORED;
                }
                return Reply.EXISTS;
            }
            return Reply.EXISTS;
        }
        return Reply.NOT_FOUND;
    }

    public static CasCommand newCasCommand(Cache cache, StorageParameters params, long cas, byte[] data, boolean noReply) {
        return new CasCommand(cache, CommandType.CAS, params, cas, data, noReply);
    }
}

