/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import org.infinispan.Cache;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.SetCommand;
import org.infinispan.server.memcached.commands.StorageParameters;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;

public class AppendCommand
extends SetCommand {
    AppendCommand(Cache<String, Value> cache, CommandType type, StorageParameters params, byte[] data, boolean noReply) {
        super(cache, type, params, data, noReply);
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitAppend(ctx, this);
    }

    @Override
    protected Reply put(String key, int flags, byte[] data) {
        Value current = (Value)this.cache.get((Object)key);
        if (current != null) {
            byte[] concatenated = this.concat(current.getData(), data);
            Value next = new Value(current.getFlags(), concatenated, current.getCas() + 1L);
            boolean replaced = this.cache.replace((Object)key, (Object)current, (Object)next);
            if (replaced) {
                return Reply.STORED;
            }
            return Reply.NOT_STORED;
        }
        return Reply.NOT_STORED;
    }

    protected byte[] concat(byte[] current, byte[] append) {
        return TextProtocolUtil.concat(current, append);
    }

    @Override
    protected Reply put(String key, int flags, byte[] data, long expiry) {
        return this.put(key, flags, data);
    }
}

