/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.SetCommand;
import org.infinispan.server.memcached.commands.StorageParameters;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;

public class AddCommand
extends SetCommand {
    AddCommand(Cache<String, Value> cache, CommandType type, StorageParameters params, byte[] data, boolean noReply) {
        super(cache, type, params, data, noReply);
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitAdd(ctx, this);
    }

    @Override
    protected Reply put(String key, int flags, byte[] data, long expiry) {
        Value value = new Value(flags, data, System.currentTimeMillis());
        Value prev = (Value)this.cache.putIfAbsent((Object)key, (Object)value, expiry, TimeUnit.MILLISECONDS);
        return this.reply(prev);
    }

    private Reply reply(Value prev) {
        if (prev == null) {
            return Reply.STORED;
        }
        return Reply.NOT_STORED;
    }
}

