/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.server.core.transport.CommandHandler;
import org.infinispan.server.core.transport.Decoder;
import org.infinispan.server.core.transport.Server;
import org.infinispan.server.core.transport.netty.NettyDecoder;
import org.infinispan.server.core.transport.netty.NettyServer;
import org.infinispan.server.memcached.InterceptorChain;
import org.infinispan.server.memcached.commands.TextCommandHandler;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.server.memcached.interceptors.TextProtocolInterceptorChainFactory;
import org.infinispan.server.memcached.transport.TextDecoder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;

public class TextServer {
    private static final Log log = LogFactory.getLog(TextServer.class);
    private final Cache<String, Value> cache;
    private final String host;
    private final int port;
    private final int masterThreads;
    private final int workerThreads;
    private final ScheduledExecutorService scheduler;
    private Server server;

    public TextServer(String host, int port, String configFile, int masterThreads, int workerThreads) throws IOException {
        this(host, port, (Cache<String, Value>)(configFile == null ? new DefaultCacheManager().getCache() : new DefaultCacheManager(configFile).getCache()), masterThreads, workerThreads);
        if (configFile == null) {
            log.debug((Object)"Using cache manager using configuration defaults");
        } else {
            log.debug((Object)"Using cache manager configured from {0}", new Object[]{configFile});
        }
    }

    public TextServer(String host, int port, Cache<String, Value> cache, int masterThreads, int workerThreads) throws IOException {
        this.host = host;
        this.port = port;
        this.masterThreads = masterThreads;
        this.workerThreads = workerThreads;
        this.cache = cache;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        InterceptorChain chain = TextProtocolInterceptorChainFactory.getInstance(this.cache).buildInterceptorChain();
        TextDecoder decoder = new TextDecoder(this.cache, chain, this.scheduler);
        NettyDecoder nettyDecoder = new NettyDecoder((Decoder)decoder, (Enum)TextDecoder.State.READ_COMMAND);
        decoder.setCheckpointer((Decoder.Checkpointer)nettyDecoder);
        TextCommandHandler commandHandler = new TextCommandHandler(this.cache, chain);
        this.server = new NettyServer((CommandHandler)commandHandler, (ChannelUpstreamHandler)nettyDecoder, null, (SocketAddress)new InetSocketAddress(this.host, this.port), this.masterThreads, this.workerThreads, this.cache.getName());
        this.server.start();
        log.info((Object)"Started Memcached text server bound to {0}:{1}", new Object[]{this.host, this.port});
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        this.cache.stop();
        this.scheduler.shutdown();
    }
}

