/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.core.configuration.SaslConfiguration;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.core.transport.SaslQopHandler;
import org.infinispan.server.memcached.MemcachedInboundAdapter;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedStatus;
import org.infinispan.server.memcached.binary.BinaryDecoder;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.server.memcached.binary.BinaryOpDecoderImpl;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;

abstract class BinaryAuthDecoder
extends BinaryDecoder {
    private SaslServer saslServer;

    protected BinaryAuthDecoder(MemcachedServer server) {
        super(server, ANONYMOUS);
    }

    protected MemcachedResponse saslListMechs(BinaryHeader header) {
        byte[] mechs = String.join((CharSequence)" ", ((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.server.getConfiguration()).authentication()).sasl().mechanisms()).getBytes(StandardCharsets.US_ASCII);
        this.response(header, MemcachedStatus.NO_ERROR, mechs);
        return this.send(header, CompletableFutures.completedNull());
    }

    protected MemcachedResponse saslAuth(BinaryHeader header, byte[] mech, byte[] data) {
        CompletionStage r = this.server.getBlockingManager().supplyBlocking(() -> {
            try {
                this.saslServer = SaslAuthenticator.createSaslServer((SaslConfiguration)((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.server.getConfiguration()).authentication()).sasl(), (Channel)this.ctx.channel(), (String)new String(mech, StandardCharsets.US_ASCII), (String)"memcached");
                return this.doSasl(header, data);
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(new SecurityException(t.getMessage()));
            }
        }, (Object)"memcached-sasl-auth").thenCompose(c -> c);
        return this.send(header, r);
    }

    protected MemcachedResponse saslStep(BinaryHeader header, byte[] mech, byte[] data) {
        CompletionStage r = this.server.getBlockingManager().supplyBlocking(() -> this.doSasl(header, data), (Object)"memcached-sasl-step").thenCompose(Function.identity());
        return this.send(header, r);
    }

    private CompletionStage<MemcachedResponse.ResponseWriter> doSasl(BinaryHeader header, byte[] data) {
        try {
            byte[] serverChallenge = this.saslServer.evaluateResponse(data);
            if (!this.saslServer.isComplete()) {
                return CompletableFuture.completedFuture(allocator -> this.response(header, MemcachedStatus.AUTHN_CONTINUE, serverChallenge));
            }
            Subject subject = (Subject)this.saslServer.getNegotiatedProperty("org.infinispan.security.Subject");
            String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
            if ("auth-int".equals(qop) || "auth-conf".equals(qop)) {
                return CompletableFuture.supplyAsync(() -> {
                    SaslQopHandler qopHandler = new SaslQopHandler(this.saslServer);
                    this.ctx.pipeline().addBefore("decoder", "saslQop", (ChannelHandler)qopHandler);
                    return allocator -> this.response(header, MemcachedStatus.NO_ERROR);
                }, (Executor)this.ctx.channel().eventLoop());
            }
            return CompletableFuture.supplyAsync(() -> {
                BinaryOpDecoderImpl decoder = new BinaryOpDecoderImpl(this.server, subject);
                MemcachedInboundAdapter inbound = (MemcachedInboundAdapter)this.ctx.pipeline().get(MemcachedInboundAdapter.class);
                decoder.registerExceptionHandler(inbound::handleExceptionally);
                this.ctx.pipeline().replace("decoder", "decoder", (ChannelHandler)decoder);
                this.disposeSaslServer();
                return allocator -> this.response(header, MemcachedStatus.NO_ERROR, serverChallenge == null ? Util.EMPTY_BYTE_ARRAY : serverChallenge);
            }, (Executor)this.ctx.channel().eventLoop());
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(new SecurityException(t.getMessage()));
        }
    }

    private void disposeSaslServer() {
        try {
            if (this.saslServer != null) {
                this.saslServer.dispose();
            }
        }
        catch (SaslException e) {
            log.debug((Object)"Exception while disposing SaslServer", (Throwable)e);
        }
        finally {
            this.saslServer = null;
        }
    }
}

