/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.memcached.ByteBufPool;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.server.memcached.text.TokenReader;

public class TextResponse
extends MemcachedResponse {
    public TextResponse(CompletionStage<?> response, Header header, GenericFutureListener<? extends Future<? super Void>> listener) {
        super(response, header, listener);
    }

    public TextResponse(Throwable failure, Header header) {
        super(failure, header);
    }

    @Override
    public void writeFailure(Throwable throwable, ByteBufPool allocator) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        Object error = cause == TokenReader.INVALID_TOKEN || cause instanceof IOException || cause instanceof IllegalArgumentException ? "CLIENT_ERROR bad command line format:  " + cause.getMessage() + "\r\n" : (cause instanceof UnsupportedOperationException ? "ERROR\r\n" : (cause instanceof SecurityException ? "CLIENT_ERROR authentication failed: " + cause.getMessage() : "SERVER_ERROR  " + cause.getMessage() + "\r\n"));
        this.useErrorMessage((String)error);
        this.responseBytes = ((String)error).length();
        ByteBuf output = allocator.acquire(this.responseBytes);
        ByteBufUtil.writeAscii((ByteBuf)output, (CharSequence)error);
    }
}

