/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import java.time.Instant;
import java.util.List;
import javax.security.auth.Subject;
import org.infinispan.commons.util.Util;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.binary.BinaryCommand;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.server.memcached.binary.BinaryIntrinsics;
import org.infinispan.server.memcached.binary.BinaryOpDecoder;

public class BinaryOpDecoderImpl
extends BinaryOpDecoder {
    private int state;
    private int requestBytes;
    private byte mc_dataType;
    private int mc_opaque;
    private BinaryCommand mc_op;
    private int mc_expiration;
    private BinaryHeader mc_header;
    private int mc_flags;
    private long mc_cas;
    private byte[] mc_fixedArray;
    private byte[] mc_key;
    private short mc_short;
    private int mc_preCommand;
    private int mc_valueLength;
    private long mc_long;
    private short mc_vbucketId;
    private int mc_totalBodyLength;
    private int mc_int;
    private int mc_verbosity;
    private BinaryCommand mc_opCode;
    private byte mc_byte;
    private long mc_initial;
    private byte mc_magic;
    private short mc_keyLength;
    private long mc_delta;
    private byte[] mc_value;
    private byte mc_extrasLength;
    private boolean deadEnd = false;

    public BinaryOpDecoderImpl(MemcachedServer server, Subject subject) {
        super(server, subject);
    }

    public BinaryOpDecoderImpl(MemcachedServer server) {
        this(server, ANONYMOUS);
    }

    private void updateHeaderParameters() {
        this.acquireHeader().replace(this.requestStart, this.requestBytes, this.principalName, this.mc_key, this.mc_opCode, this.mc_opaque, this.mc_cas);
    }

    private int mc_preCommand() {
        this.assertCacheIsReady();
        this.updateHeaderParameters();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            if (!ctx.channel().config().isAutoRead()) {
                log.tracef("Auto read was disabled, not reading next bytes yet", new Object[0]);
                return;
            }
            log.tracef("Auto read was enabled, reading next bytes", new Object[0]);
            while (this.switch1_0(ctx, buf, out)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(ctx, t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(ctx, buf, out);
            }
            case 1: {
                return this.switch1(ctx, buf, out);
            }
            case 2: {
                return this.switch2(ctx, buf, out);
            }
            case 3: {
                return this.switch3(ctx, buf, out);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                this.posBefore = buf.readerIndex();
                this.state = 2;
            }
            case 2: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_magic = this.mc_byte;
                this.state = 3;
            }
            case 3: {
                if (this.accessLogging) {
                    this.requestStart = Instant.now();
                }
                this.state = 4;
            }
            case 4: {
                if (this.mc_magic != -128) {
                    this.state = 6;
                    return true;
                }
                this.deadEnd = false;
                this.state = 7;
                return true;
            }
            case 5: {
                if (log.isTraceEnabled()) {
                    log.tracef("Parsed header: %s", (Object)this.mc_header);
                }
                this.state = 15;
                return true;
            }
            case 6: {
                throw new IllegalStateException("Error reading magic byte or message id: " + this.mc_magic);
            }
            case 7: {
                int pos = buf.readerIndex();
                this.mc_opCode = BinaryIntrinsics.opCode(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_op = this.mc_opCode;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.mc_short = BinaryIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keyLength = this.mc_short;
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_extrasLength = this.mc_byte;
                this.state = 10;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_dataType = this.mc_byte;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.mc_short = BinaryIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vbucketId = this.mc_short;
                this.state = 12;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_totalBodyLength = this.mc_int;
                this.state = 13;
            }
            case 13: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_opaque = this.mc_int;
                this.state = 14;
            }
            case 14: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_cas = this.mc_long;
                this.mc_valueLength = this.mc_totalBodyLength - this.mc_keyLength - this.mc_extrasLength;
                this.mc_header = this.acquireHeader();
                this.state = 5;
                return true;
            }
            case 15: {
                return this.userSwitch15();
            }
            case 16: {
                if (this.mc_keyLength > 0) {
                    this.state = 18;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 17;
            }
            case 17: {
                if (this.mc_header == null) {
                    this.state = 20;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 19;
                return true;
            }
            case 18: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 17;
                return true;
            }
            case 19: {
                if (out.add(this.get(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 20: {
                this.mc_preCommand = 0;
                this.state = 19;
                return true;
            }
            case 21: {
                if (this.mc_keyLength > 0) {
                    this.state = 23;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 22;
            }
            case 22: {
                if (this.mc_header == null) {
                    this.state = 25;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 24;
                return true;
            }
            case 23: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 22;
                return true;
            }
            case 24: {
                if (out.add(this.get(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 25: {
                this.mc_preCommand = 0;
                this.state = 24;
                return true;
            }
            case 26: {
                if (this.mc_keyLength > 0) {
                    this.state = 28;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 27;
            }
            case 27: {
                if (this.mc_header == null) {
                    this.state = 30;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 29;
                return true;
            }
            case 28: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 27;
                return true;
            }
            case 29: {
                if (out.add(this.get(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 30: {
                this.mc_preCommand = 0;
                this.state = 29;
                return true;
            }
            case 31: {
                if (this.mc_keyLength > 0) {
                    this.state = 33;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 32;
            }
            case 32: {
                if (this.mc_header == null) {
                    this.state = 35;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 34;
                return true;
            }
            case 33: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 32;
                return true;
            }
            case 34: {
                if (out.add(this.get(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 35: {
                this.mc_preCommand = 0;
                this.state = 34;
                return true;
            }
            case 36: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 37;
            }
            case 37: {
                if (this.mc_extrasLength > 0) {
                    this.state = 39;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 38;
            }
            case 38: {
                if (this.mc_keyLength > 0) {
                    this.state = 41;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 40;
                return true;
            }
            case 39: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 38;
                return true;
            }
            case 40: {
                if (this.mc_valueLength > 0) {
                    this.state = 43;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 42;
                return true;
            }
            case 41: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 40;
                return true;
            }
            case 42: {
                if (this.mc_header == null) {
                    this.state = 45;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 44;
                return true;
            }
            case 43: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 42;
                return true;
            }
            case 44: {
                if (out.add(this.set(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 45: {
                this.mc_preCommand = 0;
                this.state = 44;
                return true;
            }
            case 46: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 47;
            }
            case 47: {
                if (this.mc_extrasLength > 0) {
                    this.state = 49;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 48;
            }
            case 48: {
                if (this.mc_keyLength > 0) {
                    this.state = 51;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 50;
                return true;
            }
            case 49: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 48;
                return true;
            }
            case 50: {
                if (this.mc_valueLength > 0) {
                    this.state = 53;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 52;
                return true;
            }
            case 51: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 50;
                return true;
            }
            case 52: {
                if (this.mc_header == null) {
                    this.state = 55;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 54;
                return true;
            }
            case 53: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 52;
                return true;
            }
            case 54: {
                if (out.add(this.set(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 55: {
                this.mc_preCommand = 0;
                this.state = 54;
                return true;
            }
            case 56: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 57;
            }
            case 57: {
                if (this.mc_extrasLength > 0) {
                    this.state = 59;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 58;
            }
            case 58: {
                if (this.mc_keyLength > 0) {
                    this.state = 61;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 60;
                return true;
            }
            case 59: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 58;
                return true;
            }
            case 60: {
                if (this.mc_valueLength > 0) {
                    this.state = 63;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 62;
                return true;
            }
            case 61: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 60;
                return true;
            }
            case 62: {
                if (this.mc_header == null) {
                    this.state = 65;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 64;
                return true;
            }
            case 63: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 62;
                return true;
            }
        }
        return true;
    }

    private boolean switch1(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 64: {
                if (out.add(this.add(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 65: {
                this.mc_preCommand = 0;
                this.state = 64;
                return true;
            }
            case 66: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 67;
            }
            case 67: {
                if (this.mc_extrasLength > 0) {
                    this.state = 69;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 68;
            }
            case 68: {
                if (this.mc_keyLength > 0) {
                    this.state = 71;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 70;
                return true;
            }
            case 69: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 68;
                return true;
            }
            case 70: {
                if (this.mc_valueLength > 0) {
                    this.state = 73;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 72;
                return true;
            }
            case 71: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 70;
                return true;
            }
            case 72: {
                if (this.mc_header == null) {
                    this.state = 75;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 74;
                return true;
            }
            case 73: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 72;
                return true;
            }
            case 74: {
                if (out.add(this.add(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 75: {
                this.mc_preCommand = 0;
                this.state = 74;
                return true;
            }
            case 76: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 77;
            }
            case 77: {
                if (this.mc_extrasLength > 0) {
                    this.state = 79;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 78;
            }
            case 78: {
                if (this.mc_keyLength > 0) {
                    this.state = 81;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 80;
                return true;
            }
            case 79: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 78;
                return true;
            }
            case 80: {
                if (this.mc_valueLength > 0) {
                    this.state = 83;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 82;
                return true;
            }
            case 81: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 80;
                return true;
            }
            case 82: {
                if (this.mc_header == null) {
                    this.state = 85;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 84;
                return true;
            }
            case 83: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 82;
                return true;
            }
            case 84: {
                if (out.add(this.replace(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 85: {
                this.mc_preCommand = 0;
                this.state = 84;
                return true;
            }
            case 86: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 87;
            }
            case 87: {
                if (this.mc_extrasLength > 0) {
                    this.state = 89;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 88;
            }
            case 88: {
                if (this.mc_keyLength > 0) {
                    this.state = 91;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 90;
                return true;
            }
            case 89: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 88;
                return true;
            }
            case 90: {
                if (this.mc_valueLength > 0) {
                    this.state = 93;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 92;
                return true;
            }
            case 91: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 90;
                return true;
            }
            case 92: {
                if (this.mc_header == null) {
                    this.state = 95;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 94;
                return true;
            }
            case 93: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 92;
                return true;
            }
            case 94: {
                if (out.add(this.replace(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 95: {
                this.mc_preCommand = 0;
                this.state = 94;
                return true;
            }
            case 96: {
                if (this.mc_keyLength > 0) {
                    this.state = 98;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 97;
            }
            case 97: {
                if (this.mc_header == null) {
                    this.state = 100;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 99;
                return true;
            }
            case 98: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 97;
                return true;
            }
            case 99: {
                if (out.add(this.delete(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 100: {
                this.mc_preCommand = 0;
                this.state = 99;
                return true;
            }
            case 101: {
                if (this.mc_keyLength > 0) {
                    this.state = 103;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 102;
            }
            case 102: {
                if (this.mc_header == null) {
                    this.state = 105;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 104;
                return true;
            }
            case 103: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 102;
                return true;
            }
            case 104: {
                if (out.add(this.delete(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 105: {
                this.mc_preCommand = 0;
                this.state = 104;
                return true;
            }
            case 106: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 107;
            }
            case 107: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 108;
            }
            case 108: {
                if (this.mc_extrasLength > 0) {
                    this.state = 110;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 109;
            }
            case 109: {
                if (this.mc_keyLength > 0) {
                    this.state = 112;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 111;
                return true;
            }
            case 110: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 109;
                return true;
            }
            case 111: {
                if (this.mc_header == null) {
                    this.state = 114;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 113;
                return true;
            }
            case 112: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 111;
                return true;
            }
            case 113: {
                if (out.add(this.increment(this.mc_header, this.mc_key, this.mc_delta, this.mc_initial, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 114: {
                this.mc_preCommand = 0;
                this.state = 113;
                return true;
            }
            case 115: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 116;
            }
            case 116: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 117;
            }
            case 117: {
                if (this.mc_extrasLength > 0) {
                    this.state = 119;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 118;
            }
            case 118: {
                if (this.mc_keyLength > 0) {
                    this.state = 121;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 120;
                return true;
            }
            case 119: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 118;
                return true;
            }
            case 120: {
                if (this.mc_header == null) {
                    this.state = 123;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 122;
                return true;
            }
            case 121: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 120;
                return true;
            }
            case 122: {
                if (out.add(this.increment(this.mc_header, this.mc_key, this.mc_delta, this.mc_initial, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 123: {
                this.mc_preCommand = 0;
                this.state = 122;
                return true;
            }
            case 124: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 125;
            }
            case 125: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 126;
            }
            case 126: {
                if (this.mc_extrasLength > 0) {
                    this.state = 128;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 127;
            }
            case 127: {
                if (this.mc_keyLength > 0) {
                    this.state = 130;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 129;
                return true;
            }
        }
        return true;
    }

    private boolean switch2(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 128: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 127;
                return true;
            }
            case 129: {
                if (this.mc_header == null) {
                    this.state = 132;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 131;
                return true;
            }
            case 130: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 129;
                return true;
            }
            case 131: {
                if (out.add(this.increment(this.mc_header, this.mc_key, -this.mc_delta, this.mc_initial, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 132: {
                this.mc_preCommand = 0;
                this.state = 131;
                return true;
            }
            case 133: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 134;
            }
            case 134: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 135;
            }
            case 135: {
                if (this.mc_extrasLength > 0) {
                    this.state = 137;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 136;
            }
            case 136: {
                if (this.mc_keyLength > 0) {
                    this.state = 139;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 138;
                return true;
            }
            case 137: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 136;
                return true;
            }
            case 138: {
                if (this.mc_header == null) {
                    this.state = 141;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 140;
                return true;
            }
            case 139: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 138;
                return true;
            }
            case 140: {
                if (out.add(this.increment(this.mc_header, this.mc_key, -this.mc_delta, this.mc_initial, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 141: {
                this.mc_preCommand = 0;
                this.state = 140;
                return true;
            }
            case 142: {
                if (out.add(this.quit(this.mc_header, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 143: {
                this.quit(this.mc_header, true);
                this.state = 0;
                return true;
            }
            case 144: {
                if (this.mc_extrasLength > 0) {
                    this.state = 146;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 145;
            }
            case 145: {
                if (this.mc_header == null) {
                    this.state = 148;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 147;
                return true;
            }
            case 146: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 145;
                return true;
            }
            case 147: {
                if (out.add(this.flush(this.mc_header, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 148: {
                this.mc_preCommand = 0;
                this.state = 147;
                return true;
            }
            case 149: {
                if (this.mc_extrasLength > 0) {
                    this.state = 151;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 150;
            }
            case 150: {
                if (this.mc_header == null) {
                    this.state = 153;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 152;
                return true;
            }
            case 151: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 150;
                return true;
            }
            case 152: {
                this.flush(this.mc_header, this.mc_expiration, true);
                this.state = 0;
                return true;
            }
            case 153: {
                this.mc_preCommand = 0;
                this.state = 152;
                return true;
            }
            case 154: {
                this.updateHeaderParameters();
                if (out.add(this.noop(this.mc_header))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 155: {
                this.updateHeaderParameters();
                if (out.add(this.version(this.mc_header))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 156: {
                if (this.mc_keyLength > 0) {
                    this.state = 158;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 157;
            }
            case 157: {
                if (this.mc_valueLength > 0) {
                    this.state = 160;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 159;
                return true;
            }
            case 158: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 157;
                return true;
            }
            case 159: {
                if (this.mc_header == null) {
                    this.state = 162;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 161;
                return true;
            }
            case 160: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 159;
                return true;
            }
            case 161: {
                if (out.add(this.append(this.mc_header, this.mc_key, this.mc_value, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 162: {
                this.mc_preCommand = 0;
                this.state = 161;
                return true;
            }
            case 163: {
                if (this.mc_keyLength > 0) {
                    this.state = 165;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 164;
            }
            case 164: {
                if (this.mc_valueLength > 0) {
                    this.state = 167;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 166;
                return true;
            }
            case 165: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 164;
                return true;
            }
            case 166: {
                if (this.mc_header == null) {
                    this.state = 169;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 168;
                return true;
            }
            case 167: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 166;
                return true;
            }
            case 168: {
                if (out.add(this.append(this.mc_header, this.mc_key, this.mc_value, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 169: {
                this.mc_preCommand = 0;
                this.state = 168;
                return true;
            }
            case 170: {
                if (this.mc_keyLength > 0) {
                    this.state = 172;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 171;
            }
            case 171: {
                if (this.mc_valueLength > 0) {
                    this.state = 174;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 173;
                return true;
            }
            case 172: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 171;
                return true;
            }
            case 173: {
                if (this.mc_header == null) {
                    this.state = 176;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 175;
                return true;
            }
            case 174: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 173;
                return true;
            }
            case 175: {
                if (out.add(this.prepend(this.mc_header, this.mc_key, this.mc_value, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 176: {
                this.mc_preCommand = 0;
                this.state = 175;
                return true;
            }
            case 177: {
                if (this.mc_keyLength > 0) {
                    this.state = 179;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 178;
            }
            case 178: {
                if (this.mc_valueLength > 0) {
                    this.state = 181;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 180;
                return true;
            }
            case 179: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 178;
                return true;
            }
            case 180: {
                if (this.mc_header == null) {
                    this.state = 183;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 182;
                return true;
            }
            case 181: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 180;
                return true;
            }
            case 182: {
                if (out.add(this.prepend(this.mc_header, this.mc_key, this.mc_value, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 183: {
                this.mc_preCommand = 0;
                this.state = 182;
                return true;
            }
            case 184: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_verbosity = this.mc_int;
                this.state = 185;
            }
            case 185: {
                if (out.add(this.verbosityLevel(this.mc_header, this.mc_verbosity))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 186: {
                if (this.mc_extrasLength > 0) {
                    this.state = 188;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 187;
            }
            case 187: {
                if (this.mc_keyLength > 0) {
                    this.state = 190;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 189;
                return true;
            }
            case 188: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 187;
                return true;
            }
            case 189: {
                if (this.mc_header == null) {
                    this.state = 192;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 191;
                return true;
            }
            case 190: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 189;
                return true;
            }
            case 191: {
                if (out.add(this.touch(this.mc_header, this.mc_key, this.mc_expiration))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private boolean switch3(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 192: {
                this.mc_preCommand = 0;
                this.state = 191;
                return true;
            }
            case 193: {
                if (this.mc_extrasLength > 0) {
                    this.state = 195;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 194;
            }
            case 194: {
                if (this.mc_keyLength > 0) {
                    this.state = 197;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 196;
                return true;
            }
            case 195: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 194;
                return true;
            }
            case 196: {
                if (this.mc_header == null) {
                    this.state = 199;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 198;
                return true;
            }
            case 197: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 196;
                return true;
            }
            case 198: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 199: {
                this.mc_preCommand = 0;
                this.state = 198;
                return true;
            }
            case 200: {
                if (this.mc_extrasLength > 0) {
                    this.state = 202;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 201;
            }
            case 201: {
                if (this.mc_keyLength > 0) {
                    this.state = 204;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 203;
                return true;
            }
            case 202: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 201;
                return true;
            }
            case 203: {
                if (this.mc_header == null) {
                    this.state = 206;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 205;
                return true;
            }
            case 204: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 203;
                return true;
            }
            case 205: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 206: {
                this.mc_preCommand = 0;
                this.state = 205;
                return true;
            }
            case 207: {
                if (this.mc_extrasLength > 0) {
                    this.state = 209;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 208;
            }
            case 208: {
                if (this.mc_keyLength > 0) {
                    this.state = 211;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 210;
                return true;
            }
            case 209: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 208;
                return true;
            }
            case 210: {
                if (this.mc_header == null) {
                    this.state = 213;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 212;
                return true;
            }
            case 211: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 210;
                return true;
            }
            case 212: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 213: {
                this.mc_preCommand = 0;
                this.state = 212;
                return true;
            }
            case 214: {
                if (this.mc_extrasLength > 0) {
                    this.state = 216;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 215;
            }
            case 215: {
                if (this.mc_keyLength > 0) {
                    this.state = 218;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 217;
                return true;
            }
            case 216: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 215;
                return true;
            }
            case 217: {
                if (this.mc_header == null) {
                    this.state = 220;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 219;
                return true;
            }
            case 218: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 217;
                return true;
            }
            case 219: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 220: {
                this.mc_preCommand = 0;
                this.state = 219;
                return true;
            }
            case 221: {
                if (this.mc_keyLength > 0) {
                    this.state = 223;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 222;
            }
            case 222: {
                if (this.mc_header == null) {
                    this.state = 225;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 224;
                return true;
            }
            case 223: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 222;
                return true;
            }
            case 224: {
                if (out.add(this.stat(this.mc_header, this.mc_key))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 225: {
                this.mc_preCommand = 0;
                this.state = 224;
                return true;
            }
            case 226: {
                if (this.mc_keyLength > 0) {
                    this.state = 228;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 227;
            }
            case 227: {
                if (this.mc_header == null) {
                    this.state = 230;
                    return true;
                }
                this.mc_preCommand = this.mc_preCommand();
                this.state = 229;
                return true;
            }
            case 228: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 227;
                return true;
            }
            case 229: {
                if (out.add(this.config(this.mc_header, this.mc_key))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 230: {
                this.mc_preCommand = 0;
                this.state = 229;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            log.tracef("Invalid state of parsing", new Object[0]);
            this.exceptionCaught(this.mc_header, new IllegalStateException("Dead end processing request"));
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(ChannelHandlerContext ctx, Throwable t) throws Exception {
        this.state = 0;
        if (t instanceof TooLongFrameException) {
            TooLongFrameException tlfe = (TooLongFrameException)t;
            log.requestTooLarge(ctx.channel(), tlfe);
            ctx.close();
            return;
        }
        log.trace((Object)"Parsing error", t);
        this.exceptionCaught(this.mc_header, t);
    }

    private void reset() {
        this.requestBytes = 0;
        this.mc_dataType = 0;
        this.mc_opaque = 0;
        this.mc_op = null;
        this.mc_expiration = 0;
        this.mc_header = null;
        this.mc_flags = 0;
        this.mc_cas = 0L;
        this.mc_fixedArray = null;
        this.mc_key = null;
        this.mc_short = 0;
        this.mc_preCommand = 0;
        this.mc_valueLength = 0;
        this.mc_long = 0L;
        this.mc_vbucketId = 0;
        this.mc_totalBodyLength = 0;
        this.mc_int = 0;
        this.mc_verbosity = 0;
        this.mc_opCode = null;
        this.mc_byte = 0;
        this.mc_initial = 0L;
        this.mc_magic = 0;
        this.mc_keyLength = 0;
        this.mc_delta = 0L;
        this.mc_value = null;
        this.mc_extrasLength = 0;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch15() throws Exception {
        switch (this.mc_op) {
            case GET: {
                this.state = 16;
                return true;
            }
            case GETQ: {
                this.state = 21;
                return true;
            }
            case GETK: {
                this.state = 26;
                return true;
            }
            case GETKQ: {
                this.state = 31;
                return true;
            }
            case SET: {
                this.state = 36;
                return true;
            }
            case SETQ: {
                this.state = 46;
                return true;
            }
            case ADD: {
                this.state = 56;
                return true;
            }
            case ADDQ: {
                this.state = 66;
                return true;
            }
            case REPLACE: {
                this.state = 76;
                return true;
            }
            case REPLACEQ: {
                this.state = 86;
                return true;
            }
            case DELETE: {
                this.state = 96;
                return true;
            }
            case DELETEQ: {
                this.state = 101;
                return true;
            }
            case INCREMENT: {
                this.state = 106;
                return true;
            }
            case INCREMENTQ: {
                this.state = 115;
                return true;
            }
            case DECREMENT: {
                this.state = 124;
                return true;
            }
            case DECREMENTQ: {
                this.state = 133;
                return true;
            }
            case QUIT: {
                this.state = 142;
                return true;
            }
            case QUITQ: {
                this.state = 143;
                return true;
            }
            case FLUSH: {
                this.state = 144;
                return true;
            }
            case FLUSHQ: {
                this.state = 149;
                return true;
            }
            case NO_OP: {
                this.state = 154;
                return true;
            }
            case VERSION: {
                this.state = 155;
                return true;
            }
            case APPEND: {
                this.state = 156;
                return true;
            }
            case APPENDQ: {
                this.state = 163;
                return true;
            }
            case PREPEND: {
                this.state = 170;
                return true;
            }
            case PREPENDQ: {
                this.state = 177;
                return true;
            }
            case VERBOSITY: {
                this.state = 184;
                return true;
            }
            case TOUCH: {
                this.state = 186;
                return true;
            }
            case GAT: {
                this.state = 193;
                return true;
            }
            case GATQ: {
                this.state = 200;
                return true;
            }
            case GATK: {
                this.state = 207;
                return true;
            }
            case GATKQ: {
                this.state = 214;
                return true;
            }
            case STAT: {
                this.state = 221;
                return true;
            }
            case CONFIG_GET: {
                this.state = 226;
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown operation " + String.valueOf((Object)this.mc_op));
    }
}

