/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.SaslConfigurationBuilder;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.TextAuthenticationConfigurationBuilder;

public class MemcachedAuthenticationConfigurationBuilder
implements AuthenticationConfigurationBuilder<MemcachedAuthenticationConfiguration> {
    private final AttributeSet attributes;
    private final SaslConfigurationBuilder sasl = new SaslConfigurationBuilder();
    private final TextAuthenticationConfigurationBuilder text = new TextAuthenticationConfigurationBuilder();

    public MemcachedAuthenticationConfigurationBuilder(ProtocolServerConfigurationChildBuilder<?, ?, ?> builder) {
        this.attributes = MemcachedAuthenticationConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public MemcachedAuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public MemcachedAuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public MemcachedAuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(MemcachedAuthenticationConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(MemcachedAuthenticationConfiguration.ENABLED).get();
    }

    public MemcachedAuthenticationConfigurationBuilder securityRealm(String name) {
        this.attributes.attribute(MemcachedAuthenticationConfiguration.SECURITY_REALM).set((Object)name);
        return this;
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(MemcachedAuthenticationConfiguration.SECURITY_REALM).get();
    }

    public boolean hasSecurityRealm() {
        return !this.attributes.attribute(MemcachedAuthenticationConfiguration.SECURITY_REALM).isNull();
    }

    public SaslConfigurationBuilder sasl() {
        return this.sasl;
    }

    public TextAuthenticationConfigurationBuilder text() {
        return this.text;
    }

    public void validate() {
        if (this.enabled()) {
            this.sasl.validate();
            this.text.validate();
        }
    }

    public MemcachedAuthenticationConfiguration create() {
        return new MemcachedAuthenticationConfiguration(this.attributes.protect(), this.sasl.create(), this.text.create());
    }

    public Builder<?> read(MemcachedAuthenticationConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.sasl.read(template.sasl(), combine);
        this.text.read(template.text(), combine);
        return this;
    }
}

