package org.infinispan.server.memcached.binary;
import java.util.List;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.time.temporal.Temporal;
import org.infinispan.server.memcached.MemcachedServer;

public class BinaryAuthDecoderImpl extends BinaryAuthDecoder {
	private int state;
	private int requestBytes;

	private long mc_long;
	private byte mc_dataType;
	private short mc_vbucketId;
	private int mc_opaque;
	private BinaryCommand mc_op;
	private int mc_totalBodyLength;
	private int mc_int;
	private int mc_verbosity;
	private BinaryHeader mc_header;
	private long mc_cas;
	private BinaryCommand mc_opCode;
	private byte[] mc_fixedArray;
	private byte mc_byte;
	private long mc_initial;
	private byte[] mc_key;
	private byte mc_magic;
	private short mc_keyLength;
	private long mc_delta;
	private byte[] mc_value;
	private short mc_short;
	private int mc_valueLength;
	private byte mc_extrasLength;

	private boolean deadEnd = false;
	public BinaryAuthDecoderImpl(MemcachedServer server) {
		super(server);
	}

	@Override
	public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		int pos = buf.readerIndex();
		try {
			while (switch0(buf, out));
		} catch (Throwable t) {
			exceptionally(t);
		} finally {
			requestBytes += buf.readerIndex() - pos;
		}
	}

	private boolean switch0(ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 0: 
			// 
			reset(); 
			state = 1;
			// fallthrough
		case 1: 
			// 
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_magic = mc_byte;
			state = 2;
			// fallthrough
		case 2: 
			// mc.request
			requestStart = Instant.now();
			
			state = 3;
			// fallthrough
		case 3: 
			// mc.request
			if (mc_magic != org.infinispan.server.memcached.binary.BinaryConstants.MAGIC_REQ) {
				state = 5;
				return true;
			}
			deadEnd = false;
			
			state = 6;
			return true;
		case 4: 
			// mc.request
			if (log.isTraceEnabled()) log.tracef("Parsed header: %s", mc_header);
			
			state = 14;
			return true;
		case 5: 
			// mc.request/mc.header
			throw new IllegalStateException("Error reading magic byte or message id: " + mc_magic);
			
		case 6: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_opCode = org.infinispan.server.memcached.binary.BinaryIntrinsics.opCode(buf);
			if (buf.readerIndex() == pos) return false;
			mc_op = mc_opCode;
			state = 7;
			// fallthrough
		case 7: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.binary.BinaryIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_keyLength = mc_short;
			state = 8;
			// fallthrough
		case 8: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_extrasLength = mc_byte;
			state = 9;
			// fallthrough
		case 9: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_dataType = mc_byte;
			state = 10;
			// fallthrough
		case 10: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.binary.BinaryIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_vbucketId = mc_short;
			state = 11;
			// fallthrough
		case 11: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_totalBodyLength = mc_int;
			state = 12;
			// fallthrough
		case 12: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_opaque = mc_int;
			state = 13;
			// fallthrough
		case 13: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_cas = mc_long;
			mc_valueLength = mc_totalBodyLength - mc_keyLength - mc_extrasLength;
			mc_header = acquireHeader().replace(requestStart, requestBytes, principalName, mc_key, mc_opCode, mc_opaque, mc_cas);
			state = 4;
			return true;
		case 14: 
			// mc.request
			switch (mc_op) {
			case SASL_LIST_MECHS: 
				state = 15;
				return true;
			case SASL_AUTH: 
				state = 16;
				return true;
			case SASL_STEP: 
				state = 21;
				return true;
			case CONFIG_GET: 
				state = 26;
				return true;
			default: 
				throw new IllegalArgumentException("Unknown operation " + mc_op);
				
			}
		case 15: 
			// mc.request/mc.parameters
			if (out.add(saslListMechs(mc_header))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 16: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 18;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 17;
			// fallthrough
		case 17: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 20;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 19;
			return true;
		case 18: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 17;
			return true;
		case 19: 
			// mc.request/mc.parameters
			if (out.add(saslAuth(mc_header, mc_key, mc_value))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 20: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 19;
			return true;
		case 21: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 23;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 22;
			// fallthrough
		case 22: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 25;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 24;
			return true;
		case 23: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 22;
			return true;
		case 24: 
			// mc.request/mc.parameters
			if (out.add(saslStep(mc_header, mc_key, mc_value))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 25: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 24;
			return true;
		case 26: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 28;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 27;
			// fallthrough
		case 27: 
			// mc.request/mc.parameters
			if (out.add(config(mc_header, mc_key))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 28: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 27;
			return true;
		}
		return true;
	}

	private void deadEnd() {
		if (! deadEnd) {
			log.tracef("Invalid state of parsing");
			deadEnd = true;
		}
		state = 0;
	}

	private void exceptionally(Throwable t) throws Exception {
		log.trace("Parsing error", t);
		state = 0;
	}

	private void reset() {
		requestBytes = 0;
		mc_long = 0;
		mc_dataType = 0;
		mc_vbucketId = 0;
		mc_opaque = 0;
		mc_op = null;
		mc_totalBodyLength = 0;
		mc_int = 0;
		mc_verbosity = 0;
		mc_header = null;
		mc_cas = 0;
		mc_opCode = null;
		mc_fixedArray = null;
		mc_byte = 0;
		mc_initial = 0;
		mc_key = null;
		mc_magic = 0;
		mc_keyLength = 0;
		mc_delta = 0;
		mc_value = null;
		mc_short = 0;
		mc_valueLength = 0;
		mc_extrasLength = 0;
	}

	public int requestBytes() {
		return requestBytes;
	}
}
