/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public enum TextCommand {
    set,
    get,
    gets,
    add,
    delete,
    replace,
    append,
    prepend,
    incr,
    decr,
    gat,
    gats,
    touch,
    flush_all,
    cas,
    stats,
    verbosity,
    version,
    quit,
    mg,
    ms,
    md,
    ma,
    mn,
    me;

    private final byte[] identifier = this.name().getBytes(StandardCharsets.US_ASCII);
    private static final TextCommand[] VALUES;

    public static TextCommand valueOf(ByteBuf b) {
        int offset = b.readerIndex();
        block0: for (TextCommand cmd : VALUES) {
            byte[] candidate = cmd.identifier;
            if (candidate.length != b.readableBytes()) continue;
            for (int i = 0; i < candidate.length; ++i) {
                byte l = candidate[i];
                byte r = b.getByte(offset + i);
                if (l != r && l != r + 32) continue block0;
            }
            return cmd;
        }
        throw new IllegalArgumentException("Unknown command: " + b.toString(StandardCharsets.US_ASCII));
    }

    static {
        VALUES = TextCommand.values();
    }
}

