/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.memcached.MemcachedBaseDecoder;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedProtocol;

public class MemcachedChannelInitializer
implements NettyInitializer {
    private final MemcachedServer memcachedServer;
    private final MemcachedProtocol protocol;

    public MemcachedChannelInitializer(MemcachedServer memcachedServer) {
        this(memcachedServer, null);
    }

    public MemcachedChannelInitializer(MemcachedServer server, MemcachedProtocol protocol) {
        this.memcachedServer = server;
        this.protocol = protocol;
    }

    public void initializeChannel(Channel ch) {
        ChannelInboundHandler cih = this.protocol == null ? this.memcachedServer.getDecoder() : this.memcachedServer.getDecoder(this.protocol);
        ch.pipeline().addLast("decoder", (ChannelHandler)cih);
        if (cih instanceof MemcachedBaseDecoder) {
            MemcachedBaseDecoder decoder = (MemcachedBaseDecoder)cih;
            this.memcachedServer.installMemcachedInboundHandler(ch, decoder);
        }
    }
}

