/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.logging.Log$class;
import org.infinispan.server.core.transport.NettyChannelPipelineFactory;
import org.infinispan.server.core.transport.NettyTransport$;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.util.logging.LogFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Log4JLoggerFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(objectName="Transport", description="Transport component manages read and write operations to/from server.")
@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0007\u0003\u001d9+G\u000f^=Ue\u0006t7\u000f]8si*\u00111\u0001B\u0001\niJ\fgn\u001d9peRT!!\u0002\u0004\u0002\t\r|'/\u001a\u0006\u0003\u000f!\taa]3sm\u0016\u0014(BA\u0005\u000b\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\n\u0019!\ty\u0001#D\u0001\u0003\u0013\t\t\"AA\u0005Ue\u0006t7\u000f]8siB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\bY><w-\u001b8h\u0013\t9BCA\u0002M_\u001e\u0004\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u00111bU2bY\u0006|%M[3di\"Aq\u0001\u0001B\u0001B\u0003%q\u0004\u0005\u0002!C5\tA!\u0003\u0002#\t\tq\u0001K]8u_\u000e|GnU3sm\u0016\u0014\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u000f\u0015t7m\u001c3feB\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\bG\"\fgN\\3m\u0015\tQ3&A\u0003oKR$\u0018P\u0003\u0002-\u0015\u0005)!NY8tg&\u0011af\n\u0002\u0019\u0007\"\fgN\\3m\t><hn\u001d;sK\u0006l\u0007*\u00198eY\u0016\u0014\b\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u000f\u0005$GM]3tgB\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0004]\u0016$(\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0011!Q\u0004A!A!\u0002\u0013Y\u0014!D<pe.,'\u000f\u00165sK\u0006$7\u000f\u0005\u0002\u001ay%\u0011QH\u0007\u0002\u0004\u0013:$\b\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u0017%$G.\u001a+j[\u0016|W\u000f\u001e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0003\u0007\u001as!!\u0007#\n\u0005\u0015S\u0012A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\u000e\t\u0011)\u0003!\u0011!Q\u0001\n-\u000b!\u0002^2q\u001d>$U\r\\1z!\tIB*\u0003\u0002N5\t9!i\\8mK\u0006t\u0007\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u0017M,g\u000e\u001a\"vMNK'0\u001a\u0005\t#\u0002\u0011\t\u0011)A\u0005w\u0005Y!/Z2w\u0005V47+\u001b>f\u0011!\u0019\u0006A!A!\u0002\u0013Y\u0015\u0001F5t\u000f2|'-\u00197Ti\u0006$8/\u00128bE2,G\rC\u0003V\u0001\u0011\u0005a+\u0001\u0004=S:LGO\u0010\u000b\f/bK&l\u0017/^=~\u0003\u0017\r\u0005\u0002\u0010\u0001!)q\u0001\u0016a\u0001?!)A\u0005\u0016a\u0001K!)\u0001\u0007\u0016a\u0001c!)!\b\u0016a\u0001w!)q\b\u0016a\u0001w!)\u0011\t\u0016a\u0001\u0005\")!\n\u0016a\u0001\u0017\")q\n\u0016a\u0001w!)\u0011\u000b\u0016a\u0001w!)1\u000b\u0016a\u0001\u0017\"91\r\u0001b\u0001\n\u0013!\u0017AD:feZ,'o\u00115b]:,Gn]\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001nJ\u0001\u0006OJ|W\u000f]\u0005\u0003U\u001e\u00141\u0003R3gCVdGo\u00115b]:,Gn\u0012:pkBDa\u0001\u001c\u0001!\u0002\u0013)\u0017aD:feZ,'o\u00115b]:,Gn\u001d\u0011\t\u000f9\u0004!\u0019!C\u0001I\u0006\u0001\u0012mY2faR,Gm\u00115b]:,Gn\u001d\u0005\u0007a\u0002\u0001\u000b\u0011B3\u0002#\u0005\u001c7-\u001a9uK\u0012\u001c\u0005.\u00198oK2\u001c\b\u0005C\u0004s\u0001\t\u0007I\u0011B:\u0002\u0011AL\u0007/\u001a7j]\u0016,\u0012\u0001\u001e\t\u0003\u001fUL!A\u001e\u0002\u000379+G\u000f^=DQ\u0006tg.\u001a7QSB,G.\u001b8f\r\u0006\u001cGo\u001c:z\u0011\u0019A\b\u0001)A\u0005i\u0006I\u0001/\u001b9fY&tW\r\t\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u00039i\u0017m\u001d;fe\u0016CXmY;u_J,\u0012\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\u00016\u0003\u0011)H/\u001b7\n\u0007\u0005\u001daPA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u001d\tY\u0001\u0001Q\u0001\nq\fq\"\\1ti\u0016\u0014X\t_3dkR|'\u000f\t\u0005\t\u0003\u001f\u0001!\u0019!C\u0005w\u0006qqo\u001c:lKJ,\u00050Z2vi>\u0014\bbBA\n\u0001\u0001\u0006I\u0001`\u0001\u0010o>\u00148.\u001a:Fq\u0016\u001cW\u000f^8sA!I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011D\u0001\bM\u0006\u001cGo\u001c:z+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u00079LwNC\u0002\u0002&\u001d\naa]8dW\u0016$\u0018\u0002BA\u0015\u0003?\u0011QDT5p'\u0016\u0014h/\u001a:T_\u000e\\W\r^\"iC:tW\r\u001c$bGR|'/\u001f\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u001c\u0005Aa-Y2u_JL\b\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024\u0005\tBo\u001c;bY\nKH/Z:Xe&$H/\u001a8\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mb0\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003\u007f\tID\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD\u0001\"a\u0011\u0001A\u0003%\u0011QG\u0001\u0013i>$\u0018\r\u001c\"zi\u0016\u001cxK]5ui\u0016t\u0007\u0005C\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u00024\u0005qAo\u001c;bY\nKH/Z:SK\u0006$\u0007\u0002CA&\u0001\u0001\u0006I!!\u000e\u0002\u001fQ|G/\u00197CsR,7OU3bI\u0002B\u0011\"a\u0014\u0001\u0005\u0004%I!a\r\u0002!U\u001cXM\u001d\"zi\u0016\u001cxK]5ui\u0016t\u0007\u0002CA*\u0001\u0001\u0006I!!\u000e\u0002#U\u001cXM\u001d\"zi\u0016\u001cxK]5ui\u0016t\u0007\u0005C\u0005\u0002X\u0001\u0011\r\u0011\"\u0003\u00024\u0005iQo]3s\u0005f$Xm\u001d*fC\u0012D\u0001\"a\u0017\u0001A\u0003%\u0011QG\u0001\u000fkN,'OQ=uKN\u0014V-\u00193!\u0011\u001d\ty\u0006\u0001C!\u0003C\nQa\u001d;beR,\"!a\u0019\u0011\u0007e\t)'C\u0002\u0002hi\u0011A!\u00168ji\"9\u00111\u000e\u0001\u0005B\u0005\u0005\u0014\u0001B:u_BDq!a\u001c\u0001\t\u0003\t\t(\u0001\u000bhKR$v\u000e^1m\u0005f$Xm],sSR$XM\\\u000b\u0002\u0005\"\u0002\u0012QNA;\u0003\u001b\u000by)a%\u0002\u0016\u0006}\u0015\u0011\u0015\t\u0005\u0003o\nI)\u0004\u0002\u0002z)!\u00111PA?\u0003\u0015\tw-\u001a8u\u0015\u0011\ty(!!\u0002#AdWoZ5o\u0003:tw\u000e^1uS>t7O\u0003\u0003\u0002\u0004\u0006\u0015\u0015a\u00025fYB,'o\u001d\u0006\u0004\u0003\u000fS\u0011a\u0001:ic&!\u00111RA=\u0005\u0019iU\r\u001e:jG\u0006YA-[:qY\u0006Lh*Y7fC\t\t\t*A\u0014Ok6\u0014WM\u001d\u0011pM\u0002\"x\u000e^1mA9,XNY3sA=4\u0007EY=uKN\u0004sO]5ui\u0016t\u0017aD7fCN,(/Z7f]R$\u0016\u0010]3%\u0005\u0005]\u0015\u0002BAM\u00037\u000b\u0001\u0002\u0016*F\u001d\u0012\u001bV\u000b\u0015\u0006\u0005\u0003;\u000bI(A\bNK\u0006\u001cXO]3nK:$H+\u001f9f\u0003-!\u0017n\u001d9mCf$\u0016\u0010]3%\u0005\u0005\r\u0016\u0002BAS\u0003O\u000bqaU+N\u001b\u0006\u0013\u0016L\u0003\u0003\u0002*\u0006e\u0014a\u0003#jgBd\u0017-\u001f+za\u0016D\u0003\"!\u001c\u0002.\u0006u\u0016q\u0018\t\u0005\u0003_\u000bI,\u0004\u0002\u00022*!\u00111WA[\u0003-\tgN\\8uCRLwN\\:\u000b\u0007\u0005]\u0006\"A\u0002k[bLA!a/\u00022\n\u0001R*\u00198bO\u0016$\u0017\t\u001e;sS\n,H/Z\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002B\u0006Q(+\u001a;ve:\u001c\b\u0005\u001e5fAQ|G/\u00197!]Vl'-\u001a:!_\u001a\u0004#-\u001f;fg\u0002:(/\u001b;uK:\u0004#-\u001f\u0011uQ\u0016\u00043/\u001a:wKJ\u0004#-Y2lAQ|\u0007e\u00197jK:$8\u000fI<iS\u000eD\u0007%\u001b8dYV$Wm\u001d\u0011c_RD\u0007\u0005\u001d:pi>\u001cw\u000e\u001c\u0011b]\u0012\u0004So]3sA%tgm\u001c:nCRLwN\u001c\u0018\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002r\u0005\tr-\u001a;U_R\fGNQ=uKN\u0014V-\u00193)!\u0005\r\u0017QOAG\u0003\u0013\f\u0019*!&\u0002 \u0006\u0005\u0016EAAf\u0003\u0011rU/\u001c2fe\u0002zg\r\t;pi\u0006d\u0007E\\;nE\u0016\u0014\be\u001c4!Ef$Xm\u001d\u0011sK\u0006$\u0007\u0006CAb\u0003[\u000bi,a4\"\u0005\u0005E\u0017\u0001\u001e*fiV\u0014hn\u001d\u0011uQ\u0016\u0004Co\u001c;bY\u0002rW/\u001c2fe\u0002zg\r\t2zi\u0016\u001c\bE]3bI\u0002\u0012\u0017\u0010\t;iK\u0002\u001aXM\u001d<fe\u00022'o\\7!G2LWM\u001c;tA]D\u0017n\u00195!S:\u001cG.\u001e3fg\u0002\u0012w\u000e\u001e5!aJ|Go\\2pY\u0002\ng\u000e\u001a\u0011vg\u0016\u0014\b%\u001b8g_Jl\u0017\r^5p]:Bq!!6\u0001\t\u0003\t9.A\u0006hKRDun\u001d;OC6,WCAAm!\u0011\tY.!9\u000e\u0005\u0005u'bAApk\u0005!A.\u00198h\u0013\r9\u0015Q\u001c\u0015\u0011\u0003'\f)(!$\u0002f\u0006%\u00181^AP\u0003C\u000b#!a:\u0002\u0013!{7\u000f\u001e\u0011oC6,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3%\u0005\u00055\u0018\u0002BAx\u0003c\fQ\u0001\u0016*B\u0013RSA!a=\u0002z\u0005AA)\u0019;b)f\u0004X\r\u000b\u0005\u0002T\u00065\u0016QXA|C\t\tI0\u0001\u0018SKR,(O\\:!i\",\u0007\u0005[8ti\u0002\"x\u000eI<iS\u000eD\u0007\u0005\u001e5fAQ\u0014\u0018M\\:q_J$\bEY5oINt\u0003bBA\u007f\u0001\u0011\u0005\u0011q[\u0001\bO\u0016$\bk\u001c:uQA\tY0!\u001e\u0002\u000e\n\u0005\u0011\u0011^Av\u0003?\u000b\t+\t\u0002\u0003\u0004\u0005!\u0001k\u001c:uQ!\tY0!,\u0002>\n\u001d\u0011E\u0001B\u0005\u00039\u0012V\r^;s]N\u0004C\u000f[3!a>\u0014H\u000f\t;pA]D\u0017n\u00195!i\",\u0007\u0005\u001e:b]N\u0004xN\u001d;!E&tGm\u001d\u0018\t\u000f\t5\u0001\u0001\"\u0001\u0002X\u00061r-\u001a;Ok6\u0014WM],pe.,'\u000f\u00165sK\u0006$7\u000f\u000b\t\u0003\f\u0005U\u0014Q\u0012B\t\u0003S\fY/a(\u0002\"\u0006\u0012!1C\u0001\u0019\u001dVl'-\u001a:!_\u001a\u0004so\u001c:lKJ\u0004C\u000f\u001b:fC\u0012\u001c\b\u0006\u0003B\u0006\u0003[\u000biLa\u0006\"\u0005\te\u0011!\n*fiV\u0014hn\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011x_J\\WM\u001d\u0011uQJ,\u0017\rZ:/\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003/\fabZ3u\u0013\u0012dW\rV5nK>,H\u000f\u000b\t\u0003\u001c\u0005U\u0014Q\u0012B\u0011\u0003S\fY/a(\u0002\"\u0006\u0012!1E\u0001\r\u0013\u0012dW\r\t;j[\u0016|W\u000f\u001e\u0015\t\u00057\ti+!0\u0003(\u0005\u0012!\u0011F\u0001\u001a%\u0016$XO\u001d8tAQDW\rI5eY\u0016\u0004C/[7f_V$h\u0006C\u0004\u0003.\u0001!\t!a6\u0002\u001b\u001d,G\u000f\u00169d\u001d>$U\r\\1zQA\u0011Y#!\u001e\u0002\u000e\nE\u0012\u0011^Av\u0003?\u000b\t+\t\u0002\u00034\u0005aAk\u0011)!]>\u0004C-\u001a7bs\"B!1FAW\u0003{\u00139$\t\u0002\u0003:\u0005\u0019$+\u001a;ve:\u001c\be\u001e5fi\",'\u000f\t+D!\u0002rw\u000e\t3fY\u0006L\be^1tA\r|gNZ5hkJ,G\rI8sA9|GO\f\u0005\b\u0005{\u0001A\u0011AAl\u0003E9W\r^*f]\u0012\u0014UO\u001a4feNK'0\u001a\u0015\u0011\u0005w\t)(!$\u0003B\u0005%\u00181^AP\u0003C\u000b#Aa\u0011\u0002!M+g\u000e\u001a\u0011ck\u001a4WM\u001d\u0011tSj,\u0007\u0006\u0003B\u001e\u0003[\u000biLa\u0012\"\u0005\t%\u0013!\b*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001a8eA\t,hMZ3sAML'0\u001a\u0018\t\u000f\t5\u0003\u0001\"\u0001\u0002X\u0006!r-\u001a;SK\u000e,\u0017N^3Ck\u001a4WM]*ju\u0016D\u0003Ca\u0013\u0002v\u00055%\u0011KAu\u0003W\fy*!)\"\u0005\tM\u0013a\u0005*fG\u0016Lg/\u001a\u0011ck\u001a4WM\u001d\u0011tSj,\u0007\u0006\u0003B&\u0003[\u000biLa\u0016\"\u0005\te\u0013\u0001\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004#/Z2fSZ,\u0007EY;gM\u0016\u0014\be]5{K:B\u0001B!\u0018\u0001\t\u0003!!qL\u0001\u0018kB$\u0017\r^3U_R\fGNQ=uKN<&/\u001b;uK:$BA!\u0019\u0003hA\u0019\u0011Da\u0019\n\u0007\t\u0015$D\u0001\u0004B]f4\u0016\r\u001c\u0005\t\u0005S\u0012Y\u00061\u0001\u0003l\u0005\tQ\rE\u0002'\u0005[J1Aa\u001c(\u0005Q9&/\u001b;f\u0007>l\u0007\u000f\\3uS>tWI^3oi\"9!1\u000f\u0001\u0005\n\tU\u0014AG5oGJ,W.\u001a8u)>$\u0018\r\u001c\"zi\u0016\u001cxK]5ui\u0016tGC\u0002B1\u0005o\u0012Y\b\u0003\u0005\u0003z\tE\u0004\u0019AA\u001b\u0003\u0011\u0011\u0017m]3\t\u0011\t%$\u0011\u000fa\u0001\u0005WB\u0001Ba \u0001\t\u0003!!\u0011Q\u0001\u0015kB$\u0017\r^3U_R\fGNQ=uKN\u0014V-\u00193\u0015\t\t\u0005$1\u0011\u0005\t\u0005S\u0012i\b1\u0001\u0003\u0006B\u0019aEa\"\n\u0007\t%uE\u0001\u0007NKN\u001c\u0018mZ3Fm\u0016tG\u000fC\u0004\u0003\u000e\u0002!IAa$\u0002/%t7M]3nK:$Hk\u001c;bY\nKH/Z:SK\u0006$GC\u0002B1\u0005#\u0013\u0019\n\u0003\u0005\u0003z\t-\u0005\u0019AA\u001b\u0011!\u0011IGa#A\u0002\t\u0015\u0005f\u0003\u0001\u0003\u0018\nu%qTA_\u0005G\u0003B!a,\u0003\u001a&!!1TAY\u0005\u0015i%)Z1o\u0003)y'M[3di:\u000bW.Z\u0011\u0003\u0005C\u000b\u0011\u0002\u0016:b]N\u0004xN\u001d;\"\u0005\t\u0015\u0016!\u0012+sC:\u001c\bo\u001c:uA\r|W\u000e]8oK:$\b%\\1oC\u001e,7\u000f\t:fC\u0012\u0004\u0013M\u001c3!oJLG/\u001a\u0011pa\u0016\u0014\u0018\r^5p]N\u0004Co\\\u0018ge>l\u0007e]3sm\u0016\u0014h\u0006")
public class NettyTransport
extends Transport
implements Log,
ScalaObject {
    private final InetSocketAddress address;
    private final int workerThreads;
    private final int idleTimeout;
    public final String org$infinispan$server$core$transport$NettyTransport$$threadNamePrefix;
    private final boolean tcpNoDelay;
    private final int sendBufSize;
    private final int recvBufSize;
    private final boolean isGlobalStatsEnabled;
    private final DefaultChannelGroup serverChannels;
    private final DefaultChannelGroup acceptedChannels;
    private final NettyChannelPipelineFactory pipeline;
    private final ExecutorService masterExecutor;
    private final ExecutorService workerExecutor;
    private final NioServerSocketChannelFactory factory;
    private final AtomicLong totalBytesWritten;
    private final AtomicLong totalBytesRead;
    private final AtomicLong userBytesWritten;
    private final AtomicLong userBytesRead;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final JavaLog org$infinispan$server$core$logging$Log$$log() {
        if ((this.bitmap$0 & 1) != 0) return this.org$infinispan$server$core$logging$Log$$log;
        NettyTransport nettyTransport = this;
        synchronized (nettyTransport) {
            if ((this.bitmap$0 & 1) == 0) {
                this.org$infinispan$server$core$logging$Log$$log = Log$class.org$infinispan$server$core$logging$Log$$log(this);
                this.bitmap$0 |= 1;
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug(this, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug(this, msg, param1, param2);
    }

    @Override
    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log$class.debugf(this, msg, params);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log$class.trace(this, msg, param1, param2);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.trace(this, msg, param1, param2, param3);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Log$class.isTraceEnabled(this);
    }

    @Override
    public void logStartWithArgs(String args) {
        Log$class.logStartWithArgs(this, args);
    }

    @Override
    public void logPostingShutdownRequest() {
        Log$class.logPostingShutdownRequest(this);
    }

    @Override
    public void logExceptionReported(Throwable t) {
        Log$class.logExceptionReported(this, t);
    }

    @Override
    public void logServerDidNotUnbind() {
        Log$class.logServerDidNotUnbind(this);
    }

    @Override
    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log$class.logChannelStillBound(this, ch, address);
    }

    @Override
    public void logServerDidNotClose() {
        Log$class.logServerDidNotClose(this);
    }

    @Override
    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log$class.logChannelStillConnected(this, ch, address);
    }

    @Override
    public void logSettingMasterThreadsNotSupported() {
        Log$class.logSettingMasterThreadsNotSupported(this);
    }

    private DefaultChannelGroup serverChannels() {
        return this.serverChannels;
    }

    public DefaultChannelGroup acceptedChannels() {
        return this.acceptedChannels;
    }

    private NettyChannelPipelineFactory pipeline() {
        return this.pipeline;
    }

    private ExecutorService masterExecutor() {
        return this.masterExecutor;
    }

    private ExecutorService workerExecutor() {
        return this.workerExecutor;
    }

    private NioServerSocketChannelFactory factory() {
        return this.factory;
    }

    private AtomicLong totalBytesWritten() {
        return this.totalBytesWritten;
    }

    private AtomicLong totalBytesRead() {
        return this.totalBytesRead;
    }

    private AtomicLong userBytesWritten() {
        return this.userBytesWritten;
    }

    private AtomicLong userBytesRead() {
        return this.userBytesRead;
    }

    @Override
    public void start() {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)new $anon$1(this));
        if (LogFactory.IS_LOG4J_AVAILABLE) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        }
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.factory());
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipeline());
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.tcpNoDelay));
        if (this.sendBufSize > 0) {
            bootstrap.setOption("child.sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)this.sendBufSize));
        }
        if (this.recvBufSize > 0) {
            bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)this.recvBufSize));
        }
        Channel ch = bootstrap.bind((SocketAddress)this.address);
        this.serverChannels().add(ch);
    }

    @Override
    public void stop() {
        ChannelGroupFuture future = this.serverChannels().unbind().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            this.logServerDidNotUnbind();
            JavaConversions$.MODULE$.asScalaIterator(future.getGroup().iterator()).foreach((Function1)new $anonfun$stop$1(this));
        }
        this.workerExecutor().shutdown();
        this.serverChannels().close().awaitUninterruptibly();
        future = this.acceptedChannels().close().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            this.logServerDidNotClose();
            JavaConversions$.MODULE$.asScalaIterator(future.getGroup().iterator()).foreach((Function1)new $anonfun$stop$2(this));
        }
        this.pipeline().stop();
        if (this.isDebugEnabled()) {
            this.debug((Function0<String>)new $anonfun$stop$3(this));
        }
        this.factory().releaseExternalResources();
    }

    @ManagedAttribute(description="Returns the total number of bytes written by the server back to clients which includes both protocol and user information.")
    @Metric(displayName="Number of total number of bytes written", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public String getTotalBytesWritten() {
        return this.totalBytesWritten().toString();
    }

    @ManagedAttribute(description="Returns the total number of bytes read by the server from clients which includes both protocol and user information.")
    @Metric(displayName="Number of total number of bytes read", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public String getTotalBytesRead() {
        return this.totalBytesRead().toString();
    }

    @ManagedAttribute(description="Returns the host to which the transport binds.")
    @Metric(displayName="Host name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getHostName() {
        return this.address.getHostName().toString();
    }

    @ManagedAttribute(description="Returns the port to which the transport binds.")
    @Metric(displayName="Port", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getPort() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.address.getPort())).toString();
    }

    @ManagedAttribute(description="Returns the number of worker threads.")
    @Metric(displayName="Number of worker threads", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getNumberWorkerThreads() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.workerThreads)).toString();
    }

    @ManagedAttribute(description="Returns the idle timeout.")
    @Metric(displayName="Idle timeout", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getIdleTimeout() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.idleTimeout)).toString();
    }

    @ManagedAttribute(description="Returns whether TCP no delay was configured or not.")
    @Metric(displayName="TCP no delay", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getTpcNoDelay() {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)this.tcpNoDelay)).toString();
    }

    @ManagedAttribute(description="Returns the send buffer size.")
    @Metric(displayName="Send buffer size", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getSendBufferSize() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.sendBufSize)).toString();
    }

    @ManagedAttribute(description="Returns the receive buffer size.")
    @Metric(displayName="Receive buffer size", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getReceiveBufferSize() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.recvBufSize)).toString();
    }

    public Object updateTotalBytesWritten(WriteCompletionEvent e) {
        return this.incrementTotalBytesWritten(this.totalBytesWritten(), e);
    }

    private Object incrementTotalBytesWritten(AtomicLong base, WriteCompletionEvent e) {
        return this.isGlobalStatsEnabled ? BoxesRunTime.boxToLong((long)base.addAndGet(e.getWrittenAmount())) : BoxedUnit.UNIT;
    }

    public Object updateTotalBytesRead(MessageEvent e) {
        return this.incrementTotalBytesRead(this.totalBytesRead(), e);
    }

    private Object incrementTotalBytesRead(AtomicLong base, MessageEvent e) {
        return this.isGlobalStatsEnabled ? BoxesRunTime.boxToLong((long)base.addAndGet(((ChannelBuffer)e.getMessage()).readableBytes())) : BoxedUnit.UNIT;
    }

    public NettyTransport(ProtocolServer server, ChannelDownstreamHandler encoder, InetSocketAddress address, int workerThreads, int idleTimeout, String threadNamePrefix, boolean tcpNoDelay, int sendBufSize, int recvBufSize, boolean isGlobalStatsEnabled) {
        this.address = address;
        this.workerThreads = workerThreads;
        this.idleTimeout = idleTimeout;
        this.org$infinispan$server$core$transport$NettyTransport$$threadNamePrefix = threadNamePrefix;
        this.tcpNoDelay = tcpNoDelay;
        this.sendBufSize = sendBufSize;
        this.recvBufSize = recvBufSize;
        this.isGlobalStatsEnabled = isGlobalStatsEnabled;
        Log$class.$init$(this);
        this.serverChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Channels").toString());
        this.acceptedChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Accepted").toString());
        this.pipeline = new NettyChannelPipelineFactory(server, encoder, this, idleTimeout);
        this.masterExecutor = Executors.newCachedThreadPool();
        this.workerExecutor = Executors.newCachedThreadPool();
        this.factory = new NioServerSocketChannelFactory((Executor)this.masterExecutor(), (Executor)this.workerExecutor(), workerThreads);
        this.totalBytesWritten = new AtomicLong();
        this.totalBytesRead = new AtomicLong();
        this.userBytesWritten = new AtomicLong();
        this.userBytesRead = new AtomicLong();
    }
}

