/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport.netty;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.server.core.transport.netty.NettyChannelPipelineFactory;
import org.infinispan.server.core.transport.netty.NettyTransport$;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\b\u0003\u001d9+G\u000f^=Ue\u0006t7\u000f]8si*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u001dA\u0011\u0001B2pe\u0016T!!\u0003\u0006\u0002\rM,'O^3s\u0015\tYA\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005!\u0011BA\n\u0005\u0005%!&/\u00198ta>\u0014H\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0005\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0011\u0005qiR\"\u0001\u0004\n\u0005y1!A\u0004)s_R|7m\u001c7TKJ4XM\u001d\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u00059QM\\2pI\u0016\u0014\bC\u0001\u0012)\u001b\u0005\u0019#B\u0001\u0013&\u0003\u001d\u0019\u0007.\u00198oK2T!a\u0001\u0014\u000b\u0005\u001db\u0011!\u00026c_N\u001c\u0018BA\u0015$\u0005a\u0019\u0005.\u00198oK2$un\u001e8tiJ,\u0017-\u001c%b]\u0012dWM\u001d\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u00059\u0011\r\u001a3sKN\u001c\bCA\u00173\u001b\u0005q#BA\u00181\u0003\rqW\r\u001e\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dFA\u0007T_\u000e\\W\r^!eIJ,7o\u001d\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005iQ.Y:uKJ$\u0006N]3bIN\u0004\"!F\u001c\n\u0005a2\"aA%oi\"A!\b\u0001B\u0001B\u0003%a'A\u0007x_J\\WM\u001d+ie\u0016\fGm\u001d\u0005\ty\u0001\u0011\t\u0011)A\u0005m\u0005Y\u0011\u000e\u001a7f)&lWm\\;u\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\t\u00015I\u0004\u0002\u0016\u0003&\u0011!IF\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C-!Aq\t\u0001B\u0001B\u0003%\u0001*\u0001\u0006uGBtu\u000eR3mCf\u0004\"!F%\n\u0005)3\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005m\u0005Y1/\u001a8e\u0005V47+\u001b>f\u0011!q\u0005A!A!\u0002\u00131\u0014a\u0003:fGZ\u0014UOZ*ju\u0016DQ\u0001\u0015\u0001\u0005\u0002E\u000ba\u0001P5oSRtDc\u0003*U+Z;\u0006,\u0017.\\9v\u0003\"a\u0015\u0001\u000e\u0003\tAQ!C(A\u0002mAQ\u0001I(A\u0002\u0005BQaK(A\u00021BQ!N(A\u0002YBQAO(A\u0002YBQ\u0001P(A\u0002YBQAP(A\u0002}BQaR(A\u0002!CQ\u0001T(A\u0002YBQAT(A\u0002YBqa\u0018\u0001C\u0002\u0013%\u0001-\u0001\btKJ4XM]\"iC:tW\r\\:\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001Z\u0012\u0002\u000b\u001d\u0014x.\u001e9\n\u0005\u0019\u001c'a\u0005#fM\u0006,H\u000e^\"iC:tW\r\\$s_V\u0004\bB\u00025\u0001A\u0003%\u0011-A\btKJ4XM]\"iC:tW\r\\:!\u0011\u001dQ\u0007A1A\u0005\u0002\u0001\f\u0001#Y2dKB$X\rZ\"iC:tW\r\\:\t\r1\u0004\u0001\u0015!\u0003b\u0003E\t7mY3qi\u0016$7\t[1o]\u0016d7\u000f\t\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0003!\u0001\u0018\u000e]3mS:,W#\u00019\u0011\u0005M\u000b\u0018B\u0001:\u0003\u0005mqU\r\u001e;z\u0007\"\fgN\\3m!&\u0004X\r\\5oK\u001a\u000b7\r^8ss\"1A\u000f\u0001Q\u0001\nA\f\u0011\u0002]5qK2Lg.\u001a\u0011\t\u000fY\u0004!\u0019!C\u0005o\u00069a-Y2u_JLX#\u0001=\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018a\u00018j_*\u0011QpI\u0001\u0007g>\u001c7.\u001a;\n\u0005}T(!\b(j_N+'O^3s'>\u001c7.\u001a;DQ\u0006tg.\u001a7GC\u000e$xN]=\t\u000f\u0005\r\u0001\u0001)A\u0005q\u0006Aa-Y2u_JL\b\u0005\u0003\u0006\u0002\b\u0001A)\u0019!C\u0005\u0003\u0013\ta\"\\1ti\u0016\u0014X\t_3dkR|'/\u0006\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AC2p]\u000e,(O]3oi*\u0019\u0011Q\u0003\u0019\u0002\tU$\u0018\u000e\\\u0005\u0005\u00033\tyAA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011)\ti\u0002\u0001E\u0001B\u0003&\u00111B\u0001\u0010[\u0006\u001cH/\u001a:Fq\u0016\u001cW\u000f^8sA!Q\u0011\u0011\u0005\u0001\t\u0006\u0004%I!!\u0003\u0002\u001d]|'o[3s\u000bb,7-\u001e;pe\"Q\u0011Q\u0005\u0001\t\u0002\u0003\u0006K!a\u0003\u0002\u001f]|'o[3s\u000bb,7-\u001e;pe\u0002Bq!!\u000b\u0001\t\u0003\nY#A\u0003ti\u0006\u0014H/\u0006\u0002\u0002.A\u0019Q#a\f\n\u0007\u0005EbC\u0001\u0003V]&$\bbBA\u001b\u0001\u0011\u0005\u00131F\u0001\u0005gR|\u0007oB\u0004\u0002:\tA)!a\u000f\u0002\u001d9+G\u000f^=Ue\u0006t7\u000f]8siB\u00191+!\u0010\u0007\u0013\u0005\u0011A\u0011!A\t\u0006\u0005}2cBA\u001f\u0003\u0003\ni\u0005\u0006\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t\u0019\u0002\t1\fgnZ\u0005\u0005\u0003\u0017\n)E\u0001\u0004PE*,7\r\u001e\t\u00049\u0005=\u0013bAA)\r\t9Aj\\4hS:<\u0007b\u0002)\u0002>\u0011\u0005\u0011Q\u000b\u000b\u0003\u0003w\u0001")
public class NettyTransport
extends Transport
implements ScalaObject {
    private final SocketAddress address;
    private final int masterThreads;
    private final int workerThreads;
    public final String org$infinispan$server$core$transport$netty$NettyTransport$$threadNamePrefix;
    private final boolean tcpNoDelay;
    private final int sendBufSize;
    private final int recvBufSize;
    private final DefaultChannelGroup serverChannels;
    private final DefaultChannelGroup acceptedChannels;
    private final NettyChannelPipelineFactory pipeline;
    private final NioServerSocketChannelFactory factory;
    private ExecutorService masterExecutor;
    private ExecutorService workerExecutor;
    public volatile int bitmap$0;

    public static final void error(Function0<String> function0, Throwable throwable) {
        NettyTransport$.MODULE$.error(function0, throwable);
    }

    public static final void error(Function0<String> function0) {
        NettyTransport$.MODULE$.error(function0);
    }

    public static final void warn(Function0<String> function0, Throwable throwable) {
        NettyTransport$.MODULE$.warn(function0, throwable);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        NettyTransport$.MODULE$.warn(function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        NettyTransport$.MODULE$.trace(function0, seq);
    }

    public static final boolean isTraceEnabled() {
        return NettyTransport$.MODULE$.isTraceEnabled();
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        NettyTransport$.MODULE$.debug(function0, seq);
    }

    public static final boolean isDebugEnabled() {
        return NettyTransport$.MODULE$.isDebugEnabled();
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        NettyTransport$.MODULE$.info(function0, seq);
    }

    private DefaultChannelGroup serverChannels() {
        return this.serverChannels;
    }

    public DefaultChannelGroup acceptedChannels() {
        return this.acceptedChannels;
    }

    private NettyChannelPipelineFactory pipeline() {
        return this.pipeline;
    }

    private NioServerSocketChannelFactory factory() {
        return this.factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService masterExecutor() {
        if ((this.bitmap$0 & 1) != 0) return this.masterExecutor;
        NettyTransport nettyTransport = this;
        synchronized (nettyTransport) {
            if ((this.bitmap$0 & 1) == 0) {
                ExecutorService executorService;
                if (this.masterThreads == 0) {
                    if (NettyTransport$.MODULE$.isDebugEnabled()) {
                        NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$masterExecutor$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    executorService = Executors.newCachedThreadPool();
                } else {
                    if (NettyTransport$.MODULE$.isDebugEnabled()) {
                        NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$masterExecutor$2(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.masterThreads)}));
                    }
                    executorService = Executors.newFixedThreadPool(this.masterThreads);
                }
                this.masterExecutor = executorService;
                this.bitmap$0 |= 1;
            }
            return this.masterExecutor;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService workerExecutor() {
        if ((this.bitmap$0 & 4) != 0) return this.workerExecutor;
        NettyTransport nettyTransport = this;
        synchronized (nettyTransport) {
            if ((this.bitmap$0 & 4) == 0) {
                ExecutorService executorService;
                if (this.workerThreads == 0) {
                    if (NettyTransport$.MODULE$.isDebugEnabled()) {
                        NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$workerExecutor$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    executorService = Executors.newCachedThreadPool();
                } else {
                    if (NettyTransport$.MODULE$.isDebugEnabled()) {
                        NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$workerExecutor$2(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.workerThreads)}));
                    }
                    executorService = Executors.newFixedThreadPool(this.masterThreads);
                }
                this.workerExecutor = executorService;
                this.bitmap$0 |= 4;
            }
            return this.workerExecutor;
        }
    }

    @Override
    public void start() {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)new $anon$1(this));
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.factory());
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipeline());
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.tcpNoDelay));
        if (this.sendBufSize > 0) {
            bootstrap.setOption("child.sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)this.sendBufSize));
        }
        if (this.recvBufSize > 0) {
            bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)this.recvBufSize));
        }
        Channel ch = bootstrap.bind(this.address);
        this.serverChannels().add(ch);
    }

    @Override
    public void stop() {
        ChannelGroupFuture future = this.serverChannels().unbind().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            NettyTransport$.MODULE$.warn((Function0<String>)new $anonfun$stop$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            JavaConversions$.MODULE$.asIterator(future.getGroup().iterator()).foreach((Function1)new $anonfun$stop$2(this));
        }
        this.workerExecutor().shutdown();
        this.serverChannels().close().awaitUninterruptibly();
        future = this.acceptedChannels().close().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            NettyTransport$.MODULE$.warn((Function0<String>)new $anonfun$stop$3(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            JavaConversions$.MODULE$.asIterator(future.getGroup().iterator()).foreach((Function1)new $anonfun$stop$4(this));
        }
        this.pipeline().stop();
        if (NettyTransport$.MODULE$.isDebugEnabled()) {
            NettyTransport$.MODULE$.debug((Function0<String>)new $anonfun$stop$5(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        this.factory().releaseExternalResources();
    }

    public NettyTransport(ProtocolServer server, ChannelDownstreamHandler encoder, SocketAddress address, int masterThreads, int workerThreads, int idleTimeout, String threadNamePrefix, boolean tcpNoDelay, int sendBufSize, int recvBufSize) {
        this.address = address;
        this.masterThreads = masterThreads;
        this.workerThreads = workerThreads;
        this.org$infinispan$server$core$transport$netty$NettyTransport$$threadNamePrefix = threadNamePrefix;
        this.tcpNoDelay = tcpNoDelay;
        this.sendBufSize = sendBufSize;
        this.recvBufSize = recvBufSize;
        this.serverChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Channels").toString());
        this.acceptedChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Accepted").toString());
        this.pipeline = new NettyChannelPipelineFactory(server, encoder, this, idleTimeout);
        this.factory = workerThreads == 0 ? new NioServerSocketChannelFactory((Executor)this.masterExecutor(), (Executor)this.workerExecutor()) : new NioServerSocketChannelFactory((Executor)this.masterExecutor(), (Executor)this.workerExecutor(), workerThreads);
    }
}

