/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer$;
import org.infinispan.server.core.Logging;
import org.infinispan.server.core.Logging$class;
import org.infinispan.server.core.Main$;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.VersionGenerator$;
import org.infinispan.server.core.transport.Encoder;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.server.core.transport.netty.EncoderAdapter;
import org.infinispan.server.core.transport.netty.NettyTransport;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001C\u0001\u0003\t\u0003\u0005\u0019\u0011A\u0006\u0003-\u0005\u00137\u000f\u001e:bGR\u0004&o\u001c;pG>d7+\u001a:wKJT!a\u0001\u0003\u0002\t\r|'/\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0004\u000b\u00197A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\tq\u0001K]8u_\u000e|GnU3sm\u0016\u0014\bCA\u000b\u001a\u0013\tQ\"AA\u0004M_\u001e<\u0017N\\4\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0003I\u001dr!\u0001H\u0013\n\u0005\u0019j\u0012A\u0002)sK\u0012,g-\u0003\u0002)S\t11\u000b\u001e:j]\u001eT!AJ\u000f\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\tic\u0006\u0005\u0002\u0016\u0001!)!E\u000ba\u0001G!9\u0001\u0007\u0001a\u0001\n#\t\u0014\u0001\u00025pgR,\u0012a\t\u0005\bg\u0001\u0001\r\u0011\"\u00055\u0003!Awn\u001d;`I\u0015\fHCA\u001b9!\tab'\u0003\u00028;\t!QK\\5u\u0011\u001dI$'!AA\u0002\r\n1\u0001\u001f\u00132\u0011\u0019Y\u0004\u0001)Q\u0005G\u0005)\u0001n\\:uA!9Q\b\u0001a\u0001\n#q\u0014\u0001\u00029peR,\u0012a\u0010\t\u00039\u0001K!!Q\u000f\u0003\u0007%sG\u000fC\u0004D\u0001\u0001\u0007I\u0011\u0003#\u0002\u0011A|'\u000f^0%KF$\"!N#\t\u000fe\u0012\u0015\u0011!a\u0001\u007f!1q\t\u0001Q!\n}\nQ\u0001]8si\u0002Bq!\u0013\u0001A\u0002\u0013Ea(A\u0007nCN$XM\u001d+ie\u0016\fGm\u001d\u0005\b\u0017\u0002\u0001\r\u0011\"\u0005M\u0003Ei\u0017m\u001d;feRC'/Z1eg~#S-\u001d\u000b\u0003k5Cq!\u000f&\u0002\u0002\u0003\u0007q\b\u0003\u0004P\u0001\u0001\u0006KaP\u0001\u000f[\u0006\u001cH/\u001a:UQJ,\u0017\rZ:!\u0011\u001d\t\u0006\u00011A\u0005\u0012y\nQb^8sW\u0016\u0014H\u000b\u001b:fC\u0012\u001c\bbB*\u0001\u0001\u0004%\t\u0002V\u0001\u0012o>\u00148.\u001a:UQJ,\u0017\rZ:`I\u0015\fHCA\u001bV\u0011\u001dI$+!AA\u0002}Baa\u0016\u0001!B\u0013y\u0014AD<pe.,'\u000f\u00165sK\u0006$7\u000f\t\u0005\b3\u0002\u0001\r\u0011\"\u0005[\u0003%!(/\u00198ta>\u0014H/F\u0001\\!\taf,D\u0001^\u0015\tI&!\u0003\u0002`;\nIAK]1ogB|'\u000f\u001e\u0005\bC\u0002\u0001\r\u0011\"\u0005c\u00035!(/\u00198ta>\u0014Ho\u0018\u0013fcR\u0011Qg\u0019\u0005\bs\u0001\f\t\u00111\u0001\\\u0011\u0019)\u0007\u0001)Q\u00057\u0006QAO]1ogB|'\u000f\u001e\u0011\t\u000f\u001d\u0004\u0001\u0019!C\tQ\u0006a1-Y2iK6\u000bg.Y4feV\t\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002m\r\u00059Q.\u00198bO\u0016\u0014\u0018B\u00018l\u0005Q)UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\"9\u0001\u000f\u0001a\u0001\n#\t\u0018\u0001E2bG\",W*\u00198bO\u0016\u0014x\fJ3r)\t)$\u000fC\u0004:_\u0006\u0005\t\u0019A5\t\rQ\u0004\u0001\u0015)\u0003j\u00035\u0019\u0017m\u00195f\u001b\u0006t\u0017mZ3sA!)a\u000f\u0001C\u0001o\u0006)1\u000f^1siR1Q\u0007_A\u0001\u0003\u0007AQ!_;A\u0002i\f!\u0002\u001d:pa\u0016\u0014H/[3t!\tYh0D\u0001}\u0015\ti\b#\u0001\u0003vi&d\u0017BA@}\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006OV\u0004\r!\u001b\u0005\u0007\u0003\u000b)\b\u0019A \u0002\u0017\u0011,g-Y;miB{'\u000f\u001e\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u00039\u0019H/\u0019:u)J\fgn\u001d9peR$2\"NA\u0007\u0003#\tY\"a\b\u0002$!9\u0011qBA\u0004\u0001\u0004y\u0014aC5eY\u0016$\u0016.\\3pkRD\u0001\"a\u0005\u0002\b\u0001\u0007\u0011QC\u0001\u000bi\u000e\u0004hj\u001c#fY\u0006L\bc\u0001\u000f\u0002\u0018%\u0019\u0011\u0011D\u000f\u0003\u000f\t{w\u000e\\3b]\"9\u0011QDA\u0004\u0001\u0004y\u0014aC:f]\u0012\u0014UOZ*ju\u0016Dq!!\t\u0002\b\u0001\u0007q(A\u0006sK\u000e4()\u001e4TSj,\u0007\u0002CA\u0013\u0003\u000f\u0001\r!a\n\u0002\u0015QL\b/\u001a3Qe>\u00048\u000f\u0005\u0003\u0002*\u00055RBAA\u0016\u0015\tih!\u0003\u0003\u00020\u0005-\"a\u0004+za\u0016$\u0007K]8qKJ$\u0018.Z:\t\rY\u0004A\u0011AA\u001a)\u0015)\u0014QGA\u001d\u0011\u001d\t9$!\rA\u0002\r\n!\u0003\u001d:pa\u0016\u0014H/[3t\r&dWMT1nK\"1q-!\rA\u0002%Dq!!\u0010\u0001\t\u0003\ny$\u0001\u0003ti>\u0004X#A\u001b\t\r\u0005\r\u0003\u0001\"\u0001i\u0003=9W\r^\"bG\",W*\u00198bO\u0016\u0014\bBBA$\u0001\u0011\u0005\u0011'A\u0004hKRDun\u001d;\t\r\u0005-\u0003\u0001\"\u0001?\u0003\u001d9W\r\u001e)peRDq!a\u0014\u0001\t\u0003\t\t&A\tti\u0006\u0014H\u000fR3gCVdGoQ1dQ\u0016,\"!a\u0015\u0011\u0011\u0005U\u0013qKA.\u00037j\u0011AB\u0005\u0004\u000332!!B\"bG\",\u0007c\u0001\u000f\u0002^%\u0019\u0011qL\u000f\u0003\u000f9{G\u000f[5oO\u0002")
public abstract class AbstractProtocolServer
implements ProtocolServer,
Logging,
ScalaObject {
    private final String threadNamePrefix;
    private String host;
    private int port;
    private int masterThreads;
    private int workerThreads;
    private Transport transport;
    private EmbeddedCacheManager cacheManager;
    private final Log org$infinispan$server$core$Logging$$log;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Log org$infinispan$server$core$Logging$$log() {
        if ((this.bitmap$0 & 1) != 0) return this.org$infinispan$server$core$Logging$$log;
        AbstractProtocolServer abstractProtocolServer = this;
        synchronized (abstractProtocolServer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.org$infinispan$server$core$Logging$$log = Logging$class.org$infinispan$server$core$Logging$$log(this);
                this.bitmap$0 |= 1;
            }
            return this.org$infinispan$server$core$Logging$$log;
        }
    }

    @Override
    public void info(Function0<String> msg, Seq<Object> params) {
        Logging$class.info(this, msg, params);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg, Seq<Object> params) {
        Logging$class.debug(this, msg, params);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void trace(Function0<String> msg, Seq<Object> params) {
        Logging$class.trace(this, msg, params);
    }

    @Override
    public void warn(Function0<String> msg, Seq<Object> params) {
        Logging$class.warn((Logging)this, msg, params);
    }

    @Override
    public void warn(Function0<String> msg, Throwable t) {
        Logging$class.warn((Logging)this, msg, t);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Throwable t) {
        Logging$class.error(this, msg, t);
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String string) {
        this.host = string;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int n) {
        this.port = n;
    }

    public int masterThreads() {
        return this.masterThreads;
    }

    public void masterThreads_$eq(int n) {
        this.masterThreads = n;
    }

    public int workerThreads() {
        return this.workerThreads;
    }

    public void workerThreads_$eq(int n) {
        this.workerThreads = n;
    }

    public Transport transport() {
        return this.transport;
    }

    public void transport_$eq(Transport transport) {
        this.transport = transport;
    }

    public EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    public void cacheManager_$eq(EmbeddedCacheManager embeddedCacheManager) {
        this.cacheManager = embeddedCacheManager;
    }

    public void start(Properties properties, EmbeddedCacheManager cacheManager, int defaultPort) {
        TypedProperties typedProps = TypedProperties.toTypedProperties((Properties)properties);
        boolean toStart = typedProps.getBooleanProperty("enabled", true, true);
        if (toStart) {
            this.host_$eq(typedProps.getProperty(Main$.MODULE$.PROP_KEY_HOST(), Main$.MODULE$.HOST_DEFAULT(), true));
            this.port_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_PORT(), defaultPort, true));
            this.masterThreads_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_MASTER_THREADS(), Main$.MODULE$.MASTER_THREADS_DEFAULT(), true));
            if (this.masterThreads() < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Master threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)this.masterThreads())).toString());
            }
            this.workerThreads_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_WORKER_THREADS(), Main$.MODULE$.WORKER_THREADS_DEFAULT(), true));
            if (this.workerThreads() < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Worker threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)this.masterThreads())).toString());
            }
            this.cacheManager_$eq(cacheManager);
            int idleTimeout = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_IDLE_TIMEOUT(), Main$.MODULE$.IDLE_TIMEOUT_DEFAULT(), true);
            if (idleTimeout < -1) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Idle timeout can't be lower than -1: ").append((Object)BoxesRunTime.boxToInteger((int)idleTimeout)).toString());
            }
            boolean tcpNoDelay = typedProps.getBooleanProperty(Main$.MODULE$.PROP_KEY_TCP_NO_DELAY(), Main$.MODULE$.TCP_NO_DELAY_DEFAULT(), true);
            int sendBufSize = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_SEND_BUF_SIZE(), Main$.MODULE$.SEND_BUF_SIZE_DEFAULT(), true);
            if (sendBufSize < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
            }
            int recvBufSize = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_RECV_BUF_SIZE(), Main$.MODULE$.RECV_BUF_SIZE_DEFAULT(), true);
            if (recvBufSize < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
            }
            if (this.isDebugEnabled()) {
                this.debug((Function0<String>)new $anonfun$start$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.port()), BoxesRunTime.boxToInteger((int)this.masterThreads()), BoxesRunTime.boxToInteger((int)this.workerThreads()), BoxesRunTime.boxToInteger((int)idleTimeout), BoxesRunTime.boxToBoolean((boolean)tcpNoDelay), BoxesRunTime.boxToInteger((int)sendBufSize), BoxesRunTime.boxToInteger((int)recvBufSize)}));
            }
            cacheManager.addListener((Object)VersionGenerator$.MODULE$.getRankCalculatorListener());
            this.startDefaultCache();
            this.startTransport(idleTimeout, tcpNoDelay, sendBufSize, recvBufSize, typedProps);
        }
    }

    public void startTransport(int idleTimeout, boolean tcpNoDelay, int sendBufSize, int recvBufSize, TypedProperties typedProps) {
        InetSocketAddress address = new InetSocketAddress(this.host(), this.port());
        Encoder encoder = this.getEncoder();
        EncoderAdapter nettyEncoder = encoder == null ? null : new EncoderAdapter(encoder);
        this.transport_$eq(new NettyTransport(this, (ChannelDownstreamHandler)nettyEncoder, address, this.masterThreads(), this.workerThreads(), idleTimeout, this.threadNamePrefix, tcpNoDelay, sendBufSize, recvBufSize));
        this.transport().start();
    }

    @Override
    public void start(String propertiesFileName, EmbeddedCacheManager cacheManager) {
        TypedProperties propsObject = new TypedProperties();
        InputStream stream = Util.loadResourceAsStream((String)propertiesFileName);
        propsObject.load(stream);
        this.start((Properties)propsObject, cacheManager);
    }

    @Override
    public void stop() {
        boolean isDebug = this.isDebugEnabled();
        if (isDebug) {
            this.debug((Function0<String>)new $anonfun$stop$1(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.port())}));
        }
        if (this.transport() != null) {
            this.transport().stop();
        }
        if (isDebug) {
            this.debug((Function0<String>)new $anonfun$stop$2(this), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager();
    }

    public String getHost() {
        return this.host();
    }

    public int getPort() {
        return this.port();
    }

    public Cache<Nothing$, Nothing$> startDefaultCache() {
        return this.cacheManager().getCache();
    }

    public AbstractProtocolServer(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        Logging$class.$init$(this);
    }
}

