/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.Main$;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.VersionGenerator$;
import org.infinispan.server.core.transport.Encoder;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.server.core.transport.netty.EncoderAdapter;
import org.infinispan.server.core.transport.netty.NettyTransport;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001C\u0001\u0003\t\u0003\u0005\u0019\u0011A\u0006\u0003-\u0005\u00137\u000f\u001e:bGR\u0004&o\u001c;pG>d7+\u001a:wKJT!a\u0001\u0003\u0002\t\r|'/\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0004\u000b\u0019!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u00059\u0001&o\u001c;pG>d7+\u001a:wKJ\u0004\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u00111bU2bY\u0006|%M[3di\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB\u0011\u0011\u0005\n\b\u00033\tJ!a\t\u000e\u0002\rA\u0013X\rZ3g\u0013\t)cE\u0001\u0004TiJLgn\u001a\u0006\u0003GiAQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtDC\u0001\u0016,!\t)\u0002\u0001C\u0003 O\u0001\u0007\u0001\u0005C\u0004.\u0001\u0001\u0007I\u0011\u0003\u0018\u0002\t!|7\u000f^\u000b\u0002A!9\u0001\u0007\u0001a\u0001\n#\t\u0014\u0001\u00035pgR|F%Z9\u0015\u0005I*\u0004CA\r4\u0013\t!$D\u0001\u0003V]&$\bb\u0002\u001c0\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004B\u0002\u001d\u0001A\u0003&\u0001%A\u0003i_N$\b\u0005C\u0004;\u0001\u0001\u0007I\u0011C\u001e\u0002\tA|'\u000f^\u000b\u0002yA\u0011\u0011$P\u0005\u0003}i\u00111!\u00138u\u0011\u001d\u0001\u0005\u00011A\u0005\u0012\u0005\u000b\u0001\u0002]8si~#S-\u001d\u000b\u0003e\tCqAN \u0002\u0002\u0003\u0007A\b\u0003\u0004E\u0001\u0001\u0006K\u0001P\u0001\u0006a>\u0014H\u000f\t\u0005\b\r\u0002\u0001\r\u0011\"\u0005<\u00035i\u0017m\u001d;feRC'/Z1eg\"9\u0001\n\u0001a\u0001\n#I\u0015!E7bgR,'\u000f\u00165sK\u0006$7o\u0018\u0013fcR\u0011!G\u0013\u0005\bm\u001d\u000b\t\u00111\u0001=\u0011\u0019a\u0005\u0001)Q\u0005y\u0005qQ.Y:uKJ$\u0006N]3bIN\u0004\u0003b\u0002(\u0001\u0001\u0004%\tbO\u0001\u000eo>\u00148.\u001a:UQJ,\u0017\rZ:\t\u000fA\u0003\u0001\u0019!C\t#\u0006\tro\u001c:lKJ$\u0006N]3bIN|F%Z9\u0015\u0005I\u0012\u0006b\u0002\u001cP\u0003\u0003\u0005\r\u0001\u0010\u0005\u0007)\u0002\u0001\u000b\u0015\u0002\u001f\u0002\u001d]|'o[3s)\"\u0014X-\u00193tA!9a\u000b\u0001a\u0001\n#9\u0016!\u0003;sC:\u001c\bo\u001c:u+\u0005A\u0006CA-\\\u001b\u0005Q&B\u0001,\u0003\u0013\ta&LA\u0005Ue\u0006t7\u000f]8si\"9a\f\u0001a\u0001\n#y\u0016!\u0004;sC:\u001c\bo\u001c:u?\u0012*\u0017\u000f\u0006\u00023A\"9a'XA\u0001\u0002\u0004A\u0006B\u00022\u0001A\u0003&\u0001,\u0001\u0006ue\u0006t7\u000f]8si\u0002Bq\u0001\u001a\u0001A\u0002\u0013EQ-\u0001\u0007dC\u000eDW-T1oC\u001e,'/F\u0001g!\t9'.D\u0001i\u0015\tIg!A\u0004nC:\fw-\u001a:\n\u0005-D'\u0001F#nE\u0016$G-\u001a3DC\u000eDW-T1oC\u001e,'\u000fC\u0004n\u0001\u0001\u0007I\u0011\u00038\u0002!\r\f7\r[3NC:\fw-\u001a:`I\u0015\fHC\u0001\u001ap\u0011\u001d1D.!AA\u0002\u0019Da!\u001d\u0001!B\u00131\u0017!D2bG\",W*\u00198bO\u0016\u0014\b\u0005C\u0003t\u0001\u0011\u0005A/A\u0003ti\u0006\u0014H\u000f\u0006\u00033kvt\b\"\u0002<s\u0001\u00049\u0018A\u00039s_B,'\u000f^5fgB\u0011\u0001p_\u0007\u0002s*\u0011!\u0010E\u0001\u0005kRLG.\u0003\u0002}s\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b\u0011\u0014\b\u0019\u00014\t\u000b}\u0014\b\u0019\u0001\u001f\u0002\u0017\u0011,g-Y;miB{'\u000f\u001e\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u00039\u0019H/\u0019:u)J\fgn\u001d9peR$2BMA\u0004\u0003\u0017\t)\"!\u0007\u0002\u001e!9\u0011\u0011BA\u0001\u0001\u0004a\u0014aC5eY\u0016$\u0016.\\3pkRD\u0001\"!\u0004\u0002\u0002\u0001\u0007\u0011qB\u0001\u000bi\u000e\u0004hj\u001c#fY\u0006L\bcA\r\u0002\u0012%\u0019\u00111\u0003\u000e\u0003\u000f\t{w\u000e\\3b]\"9\u0011qCA\u0001\u0001\u0004a\u0014aC:f]\u0012\u0014UOZ*ju\u0016Dq!a\u0007\u0002\u0002\u0001\u0007A(A\u0006sK\u000e4()\u001e4TSj,\u0007\u0002CA\u0010\u0003\u0003\u0001\r!!\t\u0002\u0015QL\b/\u001a3Qe>\u00048\u000f\u0005\u0003\u0002$\u0005\u001dRBAA\u0013\u0015\tQh!\u0003\u0003\u0002*\u0005\u0015\"a\u0004+za\u0016$\u0007K]8qKJ$\u0018.Z:\t\rM\u0004A\u0011AA\u0017)\u0015\u0011\u0014qFA\u001a\u0011\u001d\t\t$a\u000bA\u0002\u0001\n!\u0003\u001d:pa\u0016\u0014H/[3t\r&dWMT1nK\"1A-a\u000bA\u0002\u0019Dq!a\u000e\u0001\t\u0003\nI$\u0001\u0003ti>\u0004X#\u0001\u001a\t\r\u0005u\u0002\u0001\"\u0001f\u0003=9W\r^\"bG\",W*\u00198bO\u0016\u0014\bBBA!\u0001\u0011\u0005a&A\u0004hKRDun\u001d;\t\r\u0005\u0015\u0003\u0001\"\u0001<\u0003\u001d9W\r\u001e)peRDq!!\u0013\u0001\t\u0003\tY%A\tti\u0006\u0014H\u000fR3gCVdGoQ1dQ\u0016,\"!!\u0014\u0011\u0011\u0005=\u0013\u0011KA+\u0003+j\u0011AB\u0005\u0004\u0003'2!!B\"bG\",\u0007cA\r\u0002X%\u0019\u0011\u0011\f\u000e\u0003\u000f9{G\u000f[5oO\u0002")
public abstract class AbstractProtocolServer
implements ProtocolServer,
ScalaObject {
    private final String threadNamePrefix;
    private String host;
    private int port;
    private int masterThreads;
    private int workerThreads;
    private Transport transport;
    private EmbeddedCacheManager cacheManager;

    public String host() {
        return this.host;
    }

    public void host_$eq(String string) {
        this.host = string;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int n) {
        this.port = n;
    }

    public int masterThreads() {
        return this.masterThreads;
    }

    public void masterThreads_$eq(int n) {
        this.masterThreads = n;
    }

    public int workerThreads() {
        return this.workerThreads;
    }

    public void workerThreads_$eq(int n) {
        this.workerThreads = n;
    }

    public Transport transport() {
        return this.transport;
    }

    public void transport_$eq(Transport transport) {
        this.transport = transport;
    }

    public EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    public void cacheManager_$eq(EmbeddedCacheManager embeddedCacheManager) {
        this.cacheManager = embeddedCacheManager;
    }

    public void start(Properties properties, EmbeddedCacheManager cacheManager, int defaultPort) {
        TypedProperties typedProps = TypedProperties.toTypedProperties((Properties)properties);
        boolean toStart = typedProps.getBooleanProperty("enabled", true, true);
        if (toStart) {
            this.host_$eq(typedProps.getProperty(Main$.MODULE$.PROP_KEY_HOST(), Main$.MODULE$.HOST_DEFAULT(), true));
            this.port_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_PORT(), defaultPort, true));
            this.masterThreads_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_MASTER_THREADS(), Main$.MODULE$.MASTER_THREADS_DEFAULT(), true));
            if (this.masterThreads() < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Master threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)this.masterThreads())).toString());
            }
            this.workerThreads_$eq(typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_WORKER_THREADS(), Main$.MODULE$.WORKER_THREADS_DEFAULT(), true));
            if (this.workerThreads() < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Worker threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)this.masterThreads())).toString());
            }
            this.cacheManager_$eq(cacheManager);
            int idleTimeout = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_IDLE_TIMEOUT(), Main$.MODULE$.IDLE_TIMEOUT_DEFAULT(), true);
            if (idleTimeout < -1) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Idle timeout can't be lower than -1: ").append((Object)BoxesRunTime.boxToInteger((int)idleTimeout)).toString());
            }
            boolean tcpNoDelay = typedProps.getBooleanProperty(Main$.MODULE$.PROP_KEY_TCP_NO_DELAY(), Main$.MODULE$.TCP_NO_DELAY_DEFAULT(), true);
            int sendBufSize = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_SEND_BUF_SIZE(), Main$.MODULE$.SEND_BUF_SIZE_DEFAULT(), true);
            if (sendBufSize < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
            }
            int recvBufSize = typedProps.getIntProperty(Main$.MODULE$.PROP_KEY_RECV_BUF_SIZE(), Main$.MODULE$.RECV_BUF_SIZE_DEFAULT(), true);
            if (recvBufSize < 0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
            }
            cacheManager.addListener((Object)VersionGenerator$.MODULE$.getRankCalculatorListener());
            this.startDefaultCache();
            this.startTransport(idleTimeout, tcpNoDelay, sendBufSize, recvBufSize, typedProps);
        }
    }

    public void startTransport(int idleTimeout, boolean tcpNoDelay, int sendBufSize, int recvBufSize, TypedProperties typedProps) {
        InetSocketAddress address = new InetSocketAddress(this.host(), this.port());
        Encoder encoder = this.getEncoder();
        EncoderAdapter nettyEncoder = encoder == null ? null : new EncoderAdapter(encoder);
        this.transport_$eq(new NettyTransport(this, (ChannelDownstreamHandler)nettyEncoder, address, this.masterThreads(), this.workerThreads(), idleTimeout, this.threadNamePrefix, tcpNoDelay, sendBufSize, recvBufSize));
        this.transport().start();
    }

    @Override
    public void start(String propertiesFileName, EmbeddedCacheManager cacheManager) {
        TypedProperties propsObject = new TypedProperties();
        InputStream stream = Util.loadResourceAsStream((String)propertiesFileName);
        propsObject.load(stream);
        this.start((Properties)propsObject, cacheManager);
    }

    @Override
    public void stop() {
        if (this.transport() != null) {
            this.transport().stop();
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager();
    }

    public String getHost() {
        return this.host();
    }

    public int getPort() {
        return this.port();
    }

    public Cache<Nothing$, Nothing$> startDefaultCache() {
        return this.cacheManager().getCache();
    }

    public AbstractProtocolServer(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }
}

