/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.security.AccessController;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.Version;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.Logging;
import org.infinispan.server.core.Logging$class;
import org.infinispan.server.core.Main$;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ShutdownHook;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Main$
implements Logging,
ScalaObject {
    public static final Main$ MODULE$;
    private final String PROP_KEY_PORT;
    private final String PROP_KEY_HOST;
    private final String PROP_KEY_MASTER_THREADS;
    private final String PROP_KEY_WORKER_THREADS;
    private final String PROP_KEY_CACHE_CONFIG;
    private final String PROP_KEY_PROTOCOL;
    private final String PROP_KEY_IDLE_TIMEOUT;
    private final String PROP_KEY_TCP_NO_DELAY;
    private final String PROP_KEY_SEND_BUF_SIZE;
    private final String PROP_KEY_RECV_BUF_SIZE;
    private final String PROP_KEY_PROXY_HOST;
    private final String PROP_KEY_PROXY_PORT;
    private final String HOST_DEFAULT;
    private final int MASTER_THREADS_DEFAULT;
    private final int WORKER_THREADS_DEFAULT;
    private final int IDLE_TIMEOUT_DEFAULT;
    private final boolean TCP_NO_DELAY_DEFAULT;
    private final int SEND_BUF_SIZE_DEFAULT;
    private final int RECV_BUF_SIZE_DEFAULT;
    private final Properties props;
    private ProtocolServer server;
    private final Log org$infinispan$server$core$Logging$$log;
    public volatile int bitmap$0;

    static {
        new Main$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Log org$infinispan$server$core$Logging$$log() {
        if ((this.bitmap$0 & 1) != 0) return this.org$infinispan$server$core$Logging$$log;
        Main$ main$ = this;
        synchronized (main$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.org$infinispan$server$core$Logging$$log = Logging$class.org$infinispan$server$core$Logging$$log(this);
                this.bitmap$0 |= 1;
            }
            return this.org$infinispan$server$core$Logging$$log;
        }
    }

    public void info(Function0 msg, Seq params) {
        Logging$class.info(this, msg, params);
    }

    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    public void debug(Function0 msg, Seq params) {
        Logging$class.debug(this, msg, params);
    }

    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public void trace(Function0 msg, Seq params) {
        Logging$class.trace(this, msg, params);
    }

    public void warn(Function0 msg, Seq params) {
        Logging$class.warn((Logging)this, msg, params);
    }

    public void warn(Function0 msg, Throwable t) {
        Logging$class.warn((Logging)this, msg, t);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public void error(Function0 msg, Throwable t) {
        Logging$class.error(this, msg, t);
    }

    public String PROP_KEY_PORT() {
        return this.PROP_KEY_PORT;
    }

    public String PROP_KEY_HOST() {
        return this.PROP_KEY_HOST;
    }

    public String PROP_KEY_MASTER_THREADS() {
        return this.PROP_KEY_MASTER_THREADS;
    }

    public String PROP_KEY_WORKER_THREADS() {
        return this.PROP_KEY_WORKER_THREADS;
    }

    public String PROP_KEY_CACHE_CONFIG() {
        return this.PROP_KEY_CACHE_CONFIG;
    }

    public String PROP_KEY_PROTOCOL() {
        return this.PROP_KEY_PROTOCOL;
    }

    public String PROP_KEY_IDLE_TIMEOUT() {
        return this.PROP_KEY_IDLE_TIMEOUT;
    }

    public String PROP_KEY_TCP_NO_DELAY() {
        return this.PROP_KEY_TCP_NO_DELAY;
    }

    public String PROP_KEY_SEND_BUF_SIZE() {
        return this.PROP_KEY_SEND_BUF_SIZE;
    }

    public String PROP_KEY_RECV_BUF_SIZE() {
        return this.PROP_KEY_RECV_BUF_SIZE;
    }

    public String PROP_KEY_PROXY_HOST() {
        return this.PROP_KEY_PROXY_HOST;
    }

    public String PROP_KEY_PROXY_PORT() {
        return this.PROP_KEY_PROXY_PORT;
    }

    public String HOST_DEFAULT() {
        return this.HOST_DEFAULT;
    }

    public int MASTER_THREADS_DEFAULT() {
        return this.MASTER_THREADS_DEFAULT;
    }

    public int WORKER_THREADS_DEFAULT() {
        return this.WORKER_THREADS_DEFAULT;
    }

    public int IDLE_TIMEOUT_DEFAULT() {
        return this.IDLE_TIMEOUT_DEFAULT;
    }

    public boolean TCP_NO_DELAY_DEFAULT() {
        return this.TCP_NO_DELAY_DEFAULT;
    }

    public int SEND_BUF_SIZE_DEFAULT() {
        return this.SEND_BUF_SIZE_DEFAULT;
    }

    public int RECV_BUF_SIZE_DEFAULT() {
        return this.RECV_BUF_SIZE_DEFAULT;
    }

    private Properties props() {
        return this.props;
    }

    private ProtocolServer server() {
        return this.server;
    }

    private void server_$eq(ProtocolServer protocolServer) {
        this.server = protocolServer;
    }

    public void main(String[] args$1) {
        this.info((Function0<String>)new anonfun.main.1(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])args$1).mkString(", ")}));
        anon.1 worker = new anon.1(args$1);
        Future<Void> f = Executors.newSingleThreadScheduledExecutor(new anon.2()).submit(worker);
        f.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void boot(String[] args) {
        int n;
        String string;
        String string2;
        int idleTimeout;
        this.processCommandLine(args);
        Properties properties = new Properties();
        int masterThreads = Predef$.MODULE$.augmentString(this.props().getProperty(this.PROP_KEY_MASTER_THREADS())).toInt();
        if (masterThreads < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Master threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)masterThreads)).toString());
        }
        int workerThreads = Predef$.MODULE$.augmentString(this.props().getProperty(this.PROP_KEY_WORKER_THREADS())).toInt();
        if (workerThreads < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Worker threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)masterThreads)).toString());
        }
        String protocol = this.props().getProperty(this.PROP_KEY_PROTOCOL());
        if (protocol == null) {
            System.err.println("ERROR: Please indicate protocol to run with -r parameter");
            this.showAndExit();
        }
        if ((idleTimeout = Predef$.MODULE$.augmentString(this.props().getProperty(this.PROP_KEY_IDLE_TIMEOUT())).toInt()) < -1) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Idle timeout can't be lower than -1: ").append((Object)BoxesRunTime.boxToInteger((int)idleTimeout)).toString());
        }
        String tcpNoDelay = this.props().getProperty(this.PROP_KEY_TCP_NO_DELAY());
        boolean exceptionResult1 = false;
        try {
            exceptionResult1 = Predef$.MODULE$.augmentString(tcpNoDelay).toBoolean();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"TCP no delay flag switch must be a boolean: ").append((Object)tcpNoDelay).toString());
        }
        int sendBufSize = Predef$.MODULE$.augmentString(this.props().getProperty(this.PROP_KEY_SEND_BUF_SIZE())).toInt();
        if (sendBufSize < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
        }
        int recvBufSize = Predef$.MODULE$.augmentString(this.props().getProperty(this.PROP_KEY_SEND_BUF_SIZE())).toInt();
        if (recvBufSize < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Send buffer size can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)sendBufSize)).toString());
        }
        String string3 = string2 = protocol;
        String string4 = "memcached";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = "org.infinispan.server.memcached.MemcachedServer";
        } else {
            String string5 = string2;
            String string6 = "hotrod";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                string = "org.infinispan.server.hotrod.HotRodServer";
            } else {
                String string7 = string2;
                String string8 = "websocket";
                if (string7 != null ? !string7.equals(string8) : string8 != null) throw new MatchError(string2);
                string = "org.infinispan.server.websocket.WebSocketServer";
            }
        }
        String clazz = string;
        ProtocolServer server = (ProtocolServer)Util.getInstance((String)clazz);
        if (this.props().getProperty(this.PROP_KEY_PORT()) == null) {
            String string9;
            String string10 = string9 = protocol;
            String string11 = "memcached";
            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                n = 11211;
            } else {
                String string12 = string9;
                String string13 = "hotrod";
                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                    n = 11311;
                } else {
                    String string14 = string9;
                    String string15 = "websocket";
                    if (string14 != null ? !string14.equals(string15) : string15 != null) throw new MatchError(string9);
                    n = 8181;
                }
            }
        } else {
            n = Predef$.MODULE$.augmentString(this.props().getProperty(this.PROP_KEY_PORT())).toInt();
        }
        int port = n;
        this.props().setProperty(this.PROP_KEY_PORT(), ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        String externalHost = this.props().getProperty(this.PROP_KEY_PROXY_HOST(), this.props().getProperty(this.PROP_KEY_HOST()));
        this.props().setProperty(this.PROP_KEY_PROXY_HOST(), externalHost);
        String externalPort = this.props().getProperty(this.PROP_KEY_PROXY_PORT(), this.props().getProperty(this.PROP_KEY_PORT()));
        this.props().setProperty(this.PROP_KEY_PROXY_PORT(), externalPort);
        String configFile = this.props().getProperty(this.PROP_KEY_CACHE_CONFIG());
        DefaultCacheManager cacheManager = configFile == null ? new DefaultCacheManager() : new DefaultCacheManager(configFile);
        cacheManager.getGlobalConfiguration().setShutdownHookBehavior(GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER);
        this.addShutdownHook(new ShutdownHook(server, (CacheContainer)cacheManager));
        server.start(this.props(), (EmbeddedCacheManager)cacheManager);
    }

    private void processCommandLine(String[] args) {
        String sopts = "-:hD:Vp:l:m:t:c:r:i:n:s:e:o:x:";
        LongOpt[] longOptArray = new LongOpt[14];
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("version", 0, null, 86);
        longOptArray[2] = new LongOpt("port", 1, null, 112);
        longOptArray[3] = new LongOpt("host", 1, null, 108);
        longOptArray[4] = new LongOpt("master_threads", 1, null, 109);
        longOptArray[5] = new LongOpt("worker_threads", 1, null, 116);
        longOptArray[6] = new LongOpt("cache_config", 1, null, 99);
        longOptArray[7] = new LongOpt("protocol", 1, null, 114);
        longOptArray[8] = new LongOpt("idle_timeout", 1, null, 105);
        longOptArray[9] = new LongOpt("tcp_no_delay", 1, null, 110);
        longOptArray[10] = new LongOpt("send_buf_size", 1, null, 115);
        longOptArray[11] = new LongOpt("recv_buf_size", 1, null, 101);
        longOptArray[12] = new LongOpt("proxy_host", 1, null, 111);
        longOptArray[13] = new LongOpt("proxy_port", 1, null, 120);
        LongOpt[] lopts = (LongOpt[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])longOptArray), ClassManifest$.MODULE$.classType(LongOpt.class));
        Getopt getopt = new Getopt("startServer", args, sopts, lopts);
        int code = 0;
        while ((code = getopt.getopt()) != -1) {
            int n = code;
            switch (n) {
                default: {
                    throw new Exception(new StringBuilder().append((Object)"unhandled option code: ").append((Object)BoxesRunTime.boxToInteger((int)code)).toString());
                }
                case 120: {
                    Object object = this.props().setProperty(this.PROP_KEY_PROXY_PORT(), getopt.getOptarg());
                    break;
                }
                case 116: {
                    Object object = this.props().setProperty(this.PROP_KEY_WORKER_THREADS(), getopt.getOptarg());
                    break;
                }
                case 115: {
                    Object object = this.props().setProperty(this.PROP_KEY_SEND_BUF_SIZE(), getopt.getOptarg());
                    break;
                }
                case 114: {
                    Object object = this.props().setProperty(this.PROP_KEY_PROTOCOL(), getopt.getOptarg());
                    break;
                }
                case 112: {
                    Object object = this.props().setProperty(this.PROP_KEY_PORT(), getopt.getOptarg());
                    break;
                }
                case 111: {
                    Object object = this.props().setProperty(this.PROP_KEY_PROXY_HOST(), getopt.getOptarg());
                    break;
                }
                case 110: {
                    Object object = this.props().setProperty(this.PROP_KEY_TCP_NO_DELAY(), getopt.getOptarg());
                    break;
                }
                case 109: {
                    Object object = this.props().setProperty(this.PROP_KEY_MASTER_THREADS(), getopt.getOptarg());
                    break;
                }
                case 108: {
                    Object object = this.props().setProperty(this.PROP_KEY_HOST(), getopt.getOptarg());
                    break;
                }
                case 105: {
                    Object object = this.props().setProperty(this.PROP_KEY_IDLE_TIMEOUT(), getopt.getOptarg());
                    break;
                }
                case 104: {
                    this.showAndExit();
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 101: {
                    Object object = this.props().setProperty(this.PROP_KEY_RECV_BUF_SIZE(), getopt.getOptarg());
                    break;
                }
                case 99: {
                    Object object = this.props().setProperty(this.PROP_KEY_CACHE_CONFIG(), getopt.getOptarg());
                    break;
                }
                case 86: {
                    Version.printFullVersionInformation();
                    System.exit(0);
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 68: {
                    String arg = getopt.getOptarg();
                    String name = "";
                    String value = "";
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    Object object = System.setProperty(name, value);
                    break;
                }
                case 58: 
                case 63: {
                    System.exit(1);
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 1: {
                    System.err.println(new StringBuilder().append((Object)"startServer: unused non-option argument: ").append((Object)getopt.getOptarg()).toString());
                    Object object = BoxedUnit.UNIT;
                }
            }
        }
    }

    private void addShutdownHook(Thread shutdownHook$1) {
        AccessController.doPrivileged(new anon.3(shutdownHook$1));
    }

    private void showAndExit() {
        Predef$.MODULE$.println((Object)"usage: startServer [options]");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"options:");
        Predef$.MODULE$.println((Object)"    -h, --help                         Show this help message");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -V, --version                      Show version information");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    --                                 Stop processing options");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -p, --port=<num>                   TCP port number to listen on (default: 11211 for Memcached, 11311 for Hot Rod and 8181 for WebSocket server)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -l, --host=<host or ip>            Interface to listen on (default: 127.0.0.1, localhost)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -m, --master_threads=<num>         Number of threads accepting incoming connections (default: unlimited while resources are available)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -t, --work_threads=<num>           Number of threads processing incoming requests and sending responses (default: unlimited while resources are available)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -c, --cache_config=<filename>      Cache configuration file (default: creates cache with default values)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -r, --protocol=                    Protocol to understand by the server. This is a mandatory option and you should choose one of these options");
        Predef$.MODULE$.println((Object)"          [memcached|hotrod|websocket]");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -i, --idle_timeout=<num>           Idle read timeout, in seconds, used to detect stale connections (default: -1).");
        Predef$.MODULE$.println((Object)"                                       If no new messages have been read within this time, the server disconnects the channel.");
        Predef$.MODULE$.println((Object)"                                       Passing -1 disables idle timeout.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -n, --tcp_no_delay=[true|false]    TCP no delay flag switch (default: true).");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -s, --send_buf_size=<num>          Send buffer size (default: as defined by the OS).");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -e, --recv_buf_size=<num>          Receive buffer size (default: as defined by the OS).");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -o, --proxy_host=<host or ip>      Host address to expose in topology information sent to clients. If not present, it defaults to configured host. Servers that do not transmit topology information ignore this setting.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -x, --proxy_port=<num>             Port to expose in topology information sent to clients. If not present, it defaults to configured port. Servers that do not transmit topology information ignore this setting.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -D<name>[=<value>]                 Set a system property");
        Predef$.MODULE$.println();
        System.exit(0);
    }

    private Main$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.PROP_KEY_PORT = "infinispan.server.port";
        this.PROP_KEY_HOST = "infinispan.server.host";
        this.PROP_KEY_MASTER_THREADS = "infinispan.server.master_threads";
        this.PROP_KEY_WORKER_THREADS = "infinispan.server.worker_threads";
        this.PROP_KEY_CACHE_CONFIG = "infinispan.server.cache_config";
        this.PROP_KEY_PROTOCOL = "infinispan.server.protocol";
        this.PROP_KEY_IDLE_TIMEOUT = "infinispan.server.idle_timeout";
        this.PROP_KEY_TCP_NO_DELAY = "infinispan.server.tcp_no_delay";
        this.PROP_KEY_SEND_BUF_SIZE = "infinispan.server.send_buf_size";
        this.PROP_KEY_RECV_BUF_SIZE = "infinispan.server.recv_buf_size";
        this.PROP_KEY_PROXY_HOST = "infinispan.server.proxy_host";
        this.PROP_KEY_PROXY_PORT = "infinispan.server.proxy_port";
        this.HOST_DEFAULT = "127.0.0.1";
        this.MASTER_THREADS_DEFAULT = 0;
        this.WORKER_THREADS_DEFAULT = 0;
        this.IDLE_TIMEOUT_DEFAULT = -1;
        this.TCP_NO_DELAY_DEFAULT = true;
        this.SEND_BUF_SIZE_DEFAULT = 0;
        this.RECV_BUF_SIZE_DEFAULT = 0;
        this.props = new TypedProperties(System.getProperties());
    }
}

