/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.security.AccessController;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.Version;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.server.core.Logging;
import org.infinispan.server.core.Logging$class;
import org.infinispan.server.core.Main$;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ShutdownHook;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main$
implements Logging,
ScalaObject {
    public static final Main$ MODULE$;
    private final String PROP_KEY_PORT;
    private final String PROP_KEY_HOST;
    private final String PROP_KEY_MASTER_THREADS;
    private final String PROP_KEY_WORKER_THREADS;
    private final String PROP_KEY_CACHE_CONFIG;
    private final String PROP_KEY_PROTOCOL;
    private final String PROP_KEY_IDLE_TIMEOUT;
    private final int PORT_DEFAULT;
    private final String HOST_DEFAULT;
    private final int MASTER_THREADS_DEFAULT;
    private final int WORKER_THREADS_DEFAULT;
    private final int IDLE_TIMEOUT_DEFAULT;
    private final Map<String, String> props;
    private String programName;
    private ProtocolServer server;
    private final Log org$infinispan$server$core$Logging$$log;
    public volatile int bitmap$0;

    static {
        new Main$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Log org$infinispan$server$core$Logging$$log() {
        if ((this.bitmap$0 & 1) != 0) return this.org$infinispan$server$core$Logging$$log;
        Main$ main$ = this;
        synchronized (main$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.org$infinispan$server$core$Logging$$log = Logging$class.org$infinispan$server$core$Logging$$log(this);
                this.bitmap$0 |= 1;
            }
            return this.org$infinispan$server$core$Logging$$log;
        }
    }

    public void info(Function0 msg, Seq params) {
        Logging$class.info(this, msg, params);
    }

    public void debug(Function0 msg, Seq params) {
        Logging$class.debug(this, msg, params);
    }

    public void trace(Function0 msg, Seq params) {
        Logging$class.trace(this, msg, params);
    }

    public void warn(Function0 msg, Seq params) {
        Logging$class.warn((Logging)this, msg, params);
    }

    public void warn(Function0 msg, Throwable t) {
        Logging$class.warn((Logging)this, msg, t);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public void error(Function0 msg, Throwable t) {
        Logging$class.error(this, msg, t);
    }

    public String PROP_KEY_PORT() {
        return this.PROP_KEY_PORT;
    }

    public String PROP_KEY_HOST() {
        return this.PROP_KEY_HOST;
    }

    public String PROP_KEY_MASTER_THREADS() {
        return this.PROP_KEY_MASTER_THREADS;
    }

    public String PROP_KEY_WORKER_THREADS() {
        return this.PROP_KEY_WORKER_THREADS;
    }

    public String PROP_KEY_CACHE_CONFIG() {
        return this.PROP_KEY_CACHE_CONFIG;
    }

    public String PROP_KEY_PROTOCOL() {
        return this.PROP_KEY_PROTOCOL;
    }

    public String PROP_KEY_IDLE_TIMEOUT() {
        return this.PROP_KEY_IDLE_TIMEOUT;
    }

    public int PORT_DEFAULT() {
        return this.PORT_DEFAULT;
    }

    public String HOST_DEFAULT() {
        return this.HOST_DEFAULT;
    }

    public int MASTER_THREADS_DEFAULT() {
        return this.MASTER_THREADS_DEFAULT;
    }

    public int WORKER_THREADS_DEFAULT() {
        return this.WORKER_THREADS_DEFAULT;
    }

    public int IDLE_TIMEOUT_DEFAULT() {
        return this.IDLE_TIMEOUT_DEFAULT;
    }

    private Map<String, String> props() {
        return this.props;
    }

    private String programName() {
        return this.programName;
    }

    private void programName_$eq(String string) {
        this.programName = string;
    }

    private ProtocolServer server() {
        return this.server;
    }

    private void server_$eq(ProtocolServer protocolServer) {
        this.server = protocolServer;
    }

    public void main(String[] args$1) {
        this.info((Function0<String>)new anonfun.main.1(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])args$1).mkString(", ")}));
        anon.1 worker = new anon.1(args$1);
        Future<Void> f = Executors.newSingleThreadScheduledExecutor(new anon.2()).submit(worker);
        f.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void boot(String[] args) {
        int n;
        String string;
        String temp1;
        int idleTimeout;
        Option protocol;
        int workerThreads;
        int masterThreads;
        this.processCommandLine(args);
        Option option = this.props().get((Object)this.PROP_KEY_HOST());
        None$ none$ = None$.MODULE$;
        String host = !(option != null ? !option.equals(none$) : none$ != null) ? this.HOST_DEFAULT() : (String)this.props().get((Object)this.PROP_KEY_HOST()).get();
        Option option2 = this.props().get((Object)this.PROP_KEY_MASTER_THREADS());
        None$ none$2 = None$.MODULE$;
        int n2 = !(option2 != null ? !option2.equals(none$2) : none$2 != null) ? this.MASTER_THREADS_DEFAULT() : (masterThreads = Predef$.MODULE$.augmentString((String)this.props().get((Object)this.PROP_KEY_MASTER_THREADS()).get()).toInt());
        if (masterThreads < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Master threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)masterThreads)).toString());
        }
        Option option3 = this.props().get((Object)this.PROP_KEY_WORKER_THREADS());
        None$ none$3 = None$.MODULE$;
        int n3 = !(option3 != null ? !option3.equals(none$3) : none$3 != null) ? this.WORKER_THREADS_DEFAULT() : (workerThreads = Predef$.MODULE$.augmentString((String)this.props().get((Object)this.PROP_KEY_WORKER_THREADS()).get()).toInt());
        if (workerThreads < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Worker threads can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)masterThreads)).toString());
        }
        Option configFile = this.props().get((Object)this.PROP_KEY_CACHE_CONFIG());
        Option option4 = protocol = this.props().get((Object)this.PROP_KEY_PROTOCOL());
        None$ none$4 = None$.MODULE$;
        if (!(option4 != null ? !option4.equals(none$4) : none$4 != null)) {
            System.err.println("ERROR: Please indicate protocol to run with -r parameter");
            this.showAndExit();
        }
        Option option5 = this.props().get((Object)this.PROP_KEY_IDLE_TIMEOUT());
        None$ none$5 = None$.MODULE$;
        int n4 = !(option5 != null ? !option5.equals(none$5) : none$5 != null) ? this.IDLE_TIMEOUT_DEFAULT() : (idleTimeout = Predef$.MODULE$.augmentString((String)this.props().get((Object)this.PROP_KEY_IDLE_TIMEOUT()).get()).toInt());
        if (idleTimeout < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Idle timeout can't be lower than 0: ").append((Object)BoxesRunTime.boxToInteger((int)idleTimeout)).toString());
        }
        String string2 = temp1 = (String)protocol.get();
        String string3 = "memcached";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = "org.infinispan.server.memcached.MemcachedServer";
        } else {
            String string4 = temp1;
            String string5 = "hotrod";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                string = "org.infinispan.server.hotrod.HotRodServer";
            } else {
                String string6 = temp1;
                String string7 = "websocket";
                if (string6 != null ? !string6.equals(string7) : string7 != null) throw new MatchError(temp1);
                string = "org.infinispan.server.websocket.WebSocketServer";
            }
        }
        String clazz = string;
        Option option6 = this.props().get((Object)this.PROP_KEY_PORT());
        None$ none$6 = None$.MODULE$;
        if (!(option6 != null ? !option6.equals(none$6) : none$6 != null)) {
            String temp5;
            String string8 = temp5 = (String)protocol.get();
            String string9 = "memcached";
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                n = 11211;
            } else {
                String string10 = temp5;
                String string11 = "hotrod";
                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                    n = 11311;
                } else {
                    String string12 = temp5;
                    String string13 = "websocket";
                    if (string12 != null ? !string12.equals(string13) : string13 != null) throw new MatchError(temp5);
                    n = 8181;
                }
            }
        } else {
            n = Predef$.MODULE$.augmentString((String)this.props().get((Object)this.PROP_KEY_PORT()).get()).toInt();
        }
        int port = n;
        ProtocolServer server = (ProtocolServer)Util.getInstance((String)clazz);
        Option option7 = configFile;
        None$ none$7 = None$.MODULE$;
        DefaultCacheManager cacheManager = !(option7 != null ? !option7.equals(none$7) : none$7 != null) ? new DefaultCacheManager() : new DefaultCacheManager((String)configFile.get());
        this.addShutdownHook(new ShutdownHook(server, (CacheManager)cacheManager));
        server.start(host, port, (CacheManager)cacheManager, masterThreads, workerThreads, idleTimeout);
    }

    private void processCommandLine(String[] args) {
        this.programName_$eq(System.getProperty("program.name", "startServer"));
        String sopts = "-:hD:Vp:l:m:t:c:r:";
        LongOpt[] longOptArray = new LongOpt[9];
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("version", 0, null, 86);
        longOptArray[2] = new LongOpt("port", 1, null, 112);
        longOptArray[3] = new LongOpt("host", 1, null, 108);
        longOptArray[4] = new LongOpt("master_threads", 1, null, 109);
        longOptArray[5] = new LongOpt("worker_threads", 1, null, 116);
        longOptArray[6] = new LongOpt("cache_config", 1, null, 99);
        longOptArray[7] = new LongOpt("protocol", 1, null, 114);
        longOptArray[8] = new LongOpt("idle_timeout", 1, null, 105);
        LongOpt[] lopts = (LongOpt[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])longOptArray), ClassManifest$.MODULE$.classType(LongOpt.class));
        Getopt getopt = new Getopt(this.programName(), args, sopts, lopts);
        int code = 0;
        while ((code = getopt.getopt()) != -1) {
            int temp9 = code;
            switch (temp9) {
                default: {
                    throw new Exception(new StringBuilder().append((Object)"unhandled option code: ").append((Object)BoxesRunTime.boxToInteger((int)code)).toString());
                }
                case 116: {
                    Object object = this.props().put((Object)this.PROP_KEY_WORKER_THREADS(), (Object)getopt.getOptarg());
                    break;
                }
                case 114: {
                    Object object = this.props().put((Object)this.PROP_KEY_PROTOCOL(), (Object)getopt.getOptarg());
                    break;
                }
                case 112: {
                    Object object = this.props().put((Object)this.PROP_KEY_PORT(), (Object)getopt.getOptarg());
                    break;
                }
                case 109: {
                    Object object = this.props().put((Object)this.PROP_KEY_MASTER_THREADS(), (Object)getopt.getOptarg());
                    break;
                }
                case 108: {
                    Object object = this.props().put((Object)this.PROP_KEY_HOST(), (Object)getopt.getOptarg());
                    break;
                }
                case 105: {
                    Object object = this.props().put((Object)this.PROP_KEY_IDLE_TIMEOUT(), (Object)getopt.getOptarg());
                    break;
                }
                case 104: {
                    this.showAndExit();
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 99: {
                    Object object = this.props().put((Object)this.PROP_KEY_CACHE_CONFIG(), (Object)getopt.getOptarg());
                    break;
                }
                case 86: {
                    Version.printFullVersionInformation();
                    System.exit(0);
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 68: {
                    String arg = getopt.getOptarg();
                    String name = "";
                    String value = "";
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    Object object = System.setProperty(name, value);
                    break;
                }
                case 58: 
                case 63: {
                    System.exit(1);
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case 1: {
                    System.err.println(new StringBuilder().append((Object)this.programName()).append((Object)": unused non-option argument: ").append((Object)getopt.getOptarg()).toString());
                    Object object = BoxedUnit.UNIT;
                }
            }
        }
    }

    private void addShutdownHook(Thread shutdownHook$1) {
        AccessController.doPrivileged(new anon.3(shutdownHook$1));
    }

    private void showAndExit() {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"usage: ").append((Object)this.programName()).append((Object)" [options]").toString());
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"options:");
        Predef$.MODULE$.println((Object)"    -h, --help                         Show this help message");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -V, --version                      Show version information");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    --                                 Stop processing options");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -p, --port=<num>                   TCP port number to listen on (default: 11211 for Memcached, 11311 for Hot Rod and 8181 for WebSocket server)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -l, --host=<host or ip>            Interface to listen on (default: 127.0.0.1, localhost)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -m, --master_threads=<num>         Number of threads accepting incoming connections (default: unlimited while resources are available)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -t, --work_threads=<num>           Number of threads processing incoming requests and sending responses (default: unlimited while resources are available)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -c, --cache_config=<filename>      Cache configuration file (default: creates cache with default values)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -r, --protocol=                    Protocol to understand by the server. This is a mandatory option and you should choose one of the two options");
        Predef$.MODULE$.println((Object)"          [memcached|hotrod|websocket]");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -i, --idle_timeout=<num>           Idle read timeout, in seconds, used to detect stale connections (default: 60 seconds).");
        Predef$.MODULE$.println((Object)"                                       If no new messages have been read within this time, the server disconnects the channel.");
        Predef$.MODULE$.println((Object)"                                       Passing 0 disables idle timeout.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    -D<name>[=<value>]                 Set a system property");
        Predef$.MODULE$.println();
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    private Main$() {
        void var1_1;
        MODULE$ = this;
        Logging$class.$init$(this);
        this.PROP_KEY_PORT = "infinispan.server.port";
        this.PROP_KEY_HOST = "infinispan.server.host";
        this.PROP_KEY_MASTER_THREADS = "infinispan.server.master.threads";
        this.PROP_KEY_WORKER_THREADS = "infinispan.server.worker.threads";
        this.PROP_KEY_CACHE_CONFIG = "infinispan.server.cache.config";
        this.PROP_KEY_PROTOCOL = "infinispan.server.protocol";
        this.PROP_KEY_IDLE_TIMEOUT = "infinispan.server.idle.timeout";
        this.PORT_DEFAULT = 11211;
        this.HOST_DEFAULT = "127.0.0.1";
        this.MASTER_THREADS_DEFAULT = 0;
        this.WORKER_THREADS_DEFAULT = 0;
        this.IDLE_TIMEOUT_DEFAULT = 60;
        HashMap properties$1 = new HashMap();
        Properties sysProps = System.getProperties();
        JavaConversions$.MODULE$.asIterator(JavaConversions$.MODULE$.asIterator(JavaConversions$.MODULE$.asMap(sysProps).iterator())).foreach((Function1)new anonfun.1(properties$1));
        this.props = var1_1;
    }
}

