/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport.netty;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.server.core.transport.CommandHandler;
import org.infinispan.server.core.transport.Server;
import org.infinispan.server.core.transport.netty.NettyChannelPipelineFactory;
import org.infinispan.server.core.transport.netty.NettyChannelUpstreamHandler;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class NettyServer
implements Server {
    private static final Log log = LogFactory.getLog(NettyServer.class);
    final ChannelPipelineFactory pipeline;
    final SocketAddress address;
    final ChannelFactory factory;
    final ChannelGroup serverChannels = new DefaultChannelGroup("memcached-channels");
    final ChannelGroup acceptedChannels = new DefaultChannelGroup("memcached-accepted");
    final ExecutorService masterExecutor;
    final ExecutorService workerExecutor;

    public NettyServer(CommandHandler commandHandler, ChannelUpstreamHandler decoder, ChannelDownstreamHandler encoder, SocketAddress address, int masterThreads, int workerThreads, String cacheName) {
        MemcachedThreadFactory tf = new MemcachedThreadFactory(cacheName, ExecutorType.MASTER);
        if (masterThreads == 0) {
            log.debug((Object)"Configured unlimited threads for master thread pool");
            this.masterExecutor = Executors.newCachedThreadPool(tf);
        } else {
            log.debug((Object)"Configured {0} threads for master thread pool", new Object[]{masterThreads});
            this.masterExecutor = Executors.newFixedThreadPool(masterThreads, tf);
        }
        tf = new MemcachedThreadFactory(cacheName, ExecutorType.WORKER);
        if (workerThreads == 0) {
            log.debug((Object)"Configured unlimited threads for worker thread pool");
            this.workerExecutor = Executors.newCachedThreadPool(tf);
        } else {
            log.debug((Object)"Configured {0} threads for worker thread pool", new Object[]{workerThreads});
            this.workerExecutor = Executors.newFixedThreadPool(workerThreads, tf);
        }
        NettyChannelUpstreamHandler handler = new NettyChannelUpstreamHandler(commandHandler, this.acceptedChannels);
        this.pipeline = new NettyChannelPipelineFactory(decoder, encoder, (ChannelHandler)handler);
        this.address = address;
        this.factory = workerThreads == 0 ? new NioServerSocketChannelFactory((Executor)this.masterExecutor, (Executor)this.workerExecutor) : new NioServerSocketChannelFactory((Executor)this.masterExecutor, (Executor)this.workerExecutor, workerThreads);
    }

    @Override
    public void start() {
        ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
        bootstrap.setPipelineFactory(this.pipeline);
        Channel ch = bootstrap.bind(this.address);
        this.serverChannels.add((Object)ch);
    }

    @Override
    public void stop() {
        ChannelGroupFuture future = this.serverChannels.unbind().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            log.warn((Object)"Server channel group did not completely unbind");
            for (Channel ch : future.getGroup()) {
                if (!ch.isBound()) continue;
                log.warn((Object)"{0} is still bound to {1}", new Object[]{ch, ch.getRemoteAddress()});
            }
        }
        this.masterExecutor.shutdown();
        try {
            this.masterExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.workerExecutor.shutdown();
        this.serverChannels.close().awaitUninterruptibly();
        future = this.acceptedChannels.close().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            log.warn((Object)"Channel group did not completely close");
            for (Channel ch : future.getGroup()) {
                if (!ch.isBound()) continue;
                log.warn((Object)(ch + " is still connected to " + ch.getRemoteAddress()));
            }
        }
        log.debug((Object)"Channel group completely closed, release external resources");
        this.factory.releaseExternalResources();
    }

    private static enum ExecutorType {
        MASTER(1),
        WORKER(1);

        final AtomicInteger threadCounter;

        private ExecutorType(int startIndex) {
            this.threadCounter = new AtomicInteger(startIndex);
        }

        int getAndIncrement() {
            return this.threadCounter.getAndIncrement();
        }
    }

    private static class MemcachedThreadFactory
    implements ThreadFactory {
        final String cacheName;
        final ExecutorType type;

        MemcachedThreadFactory(String cacheName, ExecutorType type) {
            this.cacheName = cacheName;
            this.type = type;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, System.getProperty("program.name") + "-" + this.cacheName + '-' + this.type.toString().toLowerCase() + '-' + this.type.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

