/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport.netty;

import org.infinispan.server.core.transport.Decoder;
import org.infinispan.server.core.transport.netty.NettyChannelBuffer;
import org.infinispan.server.core.transport.netty.NettyChannelHandlerContext;
import org.infinispan.server.core.transport.netty.NettyExceptionEvent;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;

public class NettyDecoder<T extends Enum<T>>
extends ReplayingDecoder<T>
implements Decoder.Checkpointer<T> {
    final Decoder<T> decoder;

    public NettyDecoder(Decoder<T> decoder) {
        super(true);
        this.decoder = decoder;
    }

    public NettyDecoder(Decoder<T> decoder, T initialState) {
        super(initialState, true);
        this.decoder = decoder;
    }

    protected Object decode(ChannelHandlerContext nCtx, Channel channel, ChannelBuffer nBuffer, T state) throws Exception {
        NettyChannelHandlerContext ctx = new NettyChannelHandlerContext(nCtx);
        NettyChannelBuffer buffer = new NettyChannelBuffer(nBuffer);
        return this.decoder.decode(ctx, buffer, state);
    }

    @Override
    public void checkpoint(T state) {
        super.checkpoint(state);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.decoder.exceptionCaught(new NettyChannelHandlerContext(ctx), new NettyExceptionEvent(e));
    }
}

