/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport.netty;

import java.io.UnsupportedEncodingException;
import org.infinispan.server.core.transport.ChannelBuffer;

public class NettyChannelBuffer
implements ChannelBuffer {
    private final org.jboss.netty.buffer.ChannelBuffer nettyBuffer;

    public NettyChannelBuffer(org.jboss.netty.buffer.ChannelBuffer nettyBuffer) {
        this.nettyBuffer = nettyBuffer;
    }

    public org.jboss.netty.buffer.ChannelBuffer getUnderlyingChannelBuffer() {
        return this.nettyBuffer;
    }

    @Override
    public int readUnsignedInt() {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    @Override
    public void writeUnsignedInt(int i) {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    @Override
    public long readUnsignedLong() {
        byte b = this.readByte();
        long l = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            l |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return l;
    }

    @Override
    public void writeUnsignedLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(l & 0x7FL | 0x80L));
            l >>>= 7;
        }
        this.writeByte((byte)l);
    }

    @Override
    public byte readByte() {
        return this.nettyBuffer.readByte();
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.nettyBuffer.readBytes(dst, dstIndex, length);
    }

    @Override
    public ChannelBuffer readBytes(int length) {
        return new NettyChannelBuffer(this.nettyBuffer.readBytes(length));
    }

    @Override
    public void readBytes(byte[] dst) {
        this.nettyBuffer.readBytes(dst);
    }

    @Override
    public byte[] readRangedBytes() {
        byte[] array = new byte[this.readUnsignedInt()];
        this.readBytes(array);
        return array;
    }

    @Override
    public String readString() {
        String ret;
        try {
            ret = new String(this.readRangedBytes(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding not supported", e);
        }
        return ret;
    }

    @Override
    public void writeString(String msg) {
        this.writeRangedBytes(msg.getBytes());
    }

    @Override
    public short readUnsignedByte() {
        return this.nettyBuffer.readUnsignedByte();
    }

    @Override
    public int readerIndex() {
        return this.nettyBuffer.readerIndex();
    }

    @Override
    public void writeByte(byte value) {
        this.nettyBuffer.writeByte((int)value);
    }

    @Override
    public void writeBytes(byte[] src) {
        this.nettyBuffer.writeBytes(src);
    }

    @Override
    public void writeRangedBytes(byte[] src) {
        this.writeUnsignedInt(src.length);
        this.nettyBuffer.writeBytes(src);
    }

    @Override
    public int writerIndex() {
        return this.nettyBuffer.writerIndex();
    }
}

