/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.infinispan.Version;
import org.infinispan.server.core.Protocol;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class Main {
    private static final Log log = LogFactory.getLog(Main.class);
    public static final String PROP_KEY_PORT = "infinispan.server.port";
    public static final String PROP_KEY_HOST = "infinispan.server.host";
    public static final String PROP_KEY_MASTER_THREADS = "infinispan.server.master.threads";
    public static final String PROP_KEY_WORKER_THREADS = "infinispan.server.worker.threads";
    public static final String PROP_KEY_CACHE_CONFIG = "infinispan.server.cache.config";
    public static final String PROP_KEY_PROTOCOL = "infinispan.server.protocol";
    public static final int PORT_DEFAULT = 11211;
    public static final String HOST_DEFAULT = "127.0.0.1";
    public static final int MASTER_THREADS_DEFAULT = 0;
    public static final int WORKER_THREADS_DEFAULT = 0;
    private static String programName;
    private Map<String, String> props = new HashMap<String, String>();
    private ProtocolServer server;

    public Main() {
        Properties sysProps = System.getProperties();
        for (Object propName : sysProps.keySet()) {
            String propNameString = (String)propName;
            String propValue = (String)sysProps.get(propNameString);
            this.props.put(propNameString, propValue);
        }
    }

    public void boot(String[] args) throws Exception {
        int workerThreads;
        int masterThreads;
        this.processCommandLine(args);
        int port = this.props.get(PROP_KEY_PORT) == null ? 11211 : Integer.parseInt(this.props.get(PROP_KEY_PORT));
        String host = this.props.get(PROP_KEY_HOST) == null ? HOST_DEFAULT : this.props.get(PROP_KEY_HOST);
        int n = masterThreads = this.props.get(PROP_KEY_MASTER_THREADS) == null ? 0 : Integer.parseInt(this.props.get(PROP_KEY_MASTER_THREADS));
        if (masterThreads < 0) {
            throw new IllegalArgumentException("Master threads can't be lower than 0: " + masterThreads);
        }
        int n2 = workerThreads = this.props.get(PROP_KEY_WORKER_THREADS) == null ? 0 : Integer.parseInt(this.props.get(PROP_KEY_WORKER_THREADS));
        if (workerThreads < 0) {
            throw new IllegalArgumentException("Worker threads can't be lower than 0: " + masterThreads);
        }
        String configFile = this.props.get(PROP_KEY_CACHE_CONFIG);
        String protocol = this.props.get(PROP_KEY_PROTOCOL);
        if (protocol == null) {
            System.err.println("ERROR: Please indicate protocol to run with -r parameter");
            Main.showAndExit();
        }
        Protocol p = Protocol.valueOf(protocol.toUpperCase());
        this.server = (ProtocolServer)Util.getInstance((String)p.clazz);
        Main.addShutdownHook(new ShutdownHook(this.server));
        this.server.start(host, port, configFile, masterThreads, workerThreads);
    }

    private void processCommandLine(String[] args) throws Exception {
        int code;
        programName = System.getProperty("program.name", "startServer");
        String sopts = "-:hD:Vp:l:m:t:c:r:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 86), new LongOpt("port", 1, null, 112), new LongOpt("host", 1, null, 108), new LongOpt("master_threads", 1, null, 109), new LongOpt("worker_threads", 1, null, 116), new LongOpt("cache_config", 1, null, 99), new LongOpt("protocol", 1, null, 114)};
        Getopt getopt = new Getopt(programName, args, sopts, lopts);
        block13: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    System.exit(1);
                    continue block13;
                }
                case 1: {
                    System.err.println(programName + ": unused non-option argument: " + getopt.getOptarg());
                    continue block13;
                }
                case 104: {
                    Main.showAndExit();
                    continue block13;
                }
                case 86: {
                    Version.printFullVersionInformation();
                    System.exit(0);
                    continue block13;
                }
                case 112: {
                    this.props.put(PROP_KEY_PORT, getopt.getOptarg());
                    continue block13;
                }
                case 108: {
                    this.props.put(PROP_KEY_HOST, getopt.getOptarg());
                    continue block13;
                }
                case 109: {
                    this.props.put(PROP_KEY_MASTER_THREADS, getopt.getOptarg());
                    continue block13;
                }
                case 116: {
                    this.props.put(PROP_KEY_WORKER_THREADS, getopt.getOptarg());
                    continue block13;
                }
                case 99: {
                    this.props.put(PROP_KEY_CACHE_CONFIG, getopt.getOptarg());
                    continue block13;
                }
                case 114: {
                    this.props.put(PROP_KEY_PROTOCOL, getopt.getOptarg());
                    continue block13;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    continue block13;
                }
            }
            throw new Error("unhandled option code: " + code);
        }
    }

    public static void main(final String[] args) throws Exception {
        log.info((Object)"Start main with args: {0}", new Object[]{Arrays.toString(args)});
        Callable<Void> worker = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Main main = new Main();
                    main.boot(args);
                }
                catch (Exception e) {
                    System.err.println("Failed to boot JBoss:");
                    e.printStackTrace();
                    throw e;
                }
                return null;
            }
        };
        Future<Void> f = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "InfinispanServer-Main");
            }
        }).submit(worker);
        f.get();
    }

    private static void addShutdownHook(final Thread shutdownHook) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                return null;
            }
        });
    }

    private static void showAndExit() {
        System.out.println("usage: " + programName + " [options]");
        System.out.println();
        System.out.println("options:");
        System.out.println("    -h, --help                         Show this help message");
        System.out.println("    -V, --version                      Show version information");
        System.out.println("    --                                 Stop processing options");
        System.out.println("    -p, --port=<num>                   TCP port number to listen on (default: 11211)");
        System.out.println("    -l, --host=<host or ip>            Interface to listen on (default: 127.0.0.1, localhost)");
        System.out.println("    -m, --master_threads=<num>         Number of threads accepting incoming connections (default: unlimited while resources are available)");
        System.out.println("    -t, --work_threads=<num>           Number of threads processing incoming requests and sending responses (default: unlimited while resources are available)");
        System.out.println("    -c, --cache_config=<filename>      Cache configuration file (default: creates cache with default values)");
        System.out.println("    -r, --protocol=[memcached|hotrod]  Protocol to understand by the server. This is a mandatory option and you should choose one of the two options");
        System.out.println("    -D<name>[=<value>]                 Set a system property");
        System.out.println();
        System.exit(0);
    }

    private static class ShutdownHook
    extends Thread {
        private final ProtocolServer server;

        ShutdownHook(ProtocolServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            if (this.server != null) {
                System.out.println("Posting Shutdown Request to the server...");
                Future<Void> f = Executors.newSingleThreadExecutor().submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ShutdownHook.this.server.stop();
                        return null;
                    }
                });
                try {
                    f.get();
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Exception encountered in shutting down the server", e);
                }
            }
        }
    }
}

