/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.group.ChannelGroup;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.Transport;

public class NettyTransportConnectionStats {
    private final EmbeddedCacheManager cacheManager;
    private final boolean isGlobalStatsEnabled;
    private final ChannelGroup acceptedChannels;
    private final String threadNamePrefix;
    private final AtomicLong totalBytesWritten = new AtomicLong();
    private final AtomicLong totalBytesRead = new AtomicLong();

    NettyTransportConnectionStats(EmbeddedCacheManager cacheManager, ChannelGroup acceptedChannels, String threadNamePrefix) {
        this.cacheManager = cacheManager;
        this.acceptedChannels = acceptedChannels;
        this.threadNamePrefix = threadNamePrefix;
        this.isGlobalStatsEnabled = cacheManager != null && SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)cacheManager).statistics();
    }

    private void increment(AtomicLong base, long bytes) {
        if (this.isGlobalStatsEnabled) {
            base.addAndGet(bytes);
        }
    }

    public void incrementTotalBytesWritten(long bytes) {
        this.increment(this.totalBytesWritten, bytes);
    }

    public void incrementTotalBytesRead(long bytes) {
        this.increment(this.totalBytesRead, bytes);
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead.get();
    }

    private boolean needDistributedCalculation() {
        if (this.cacheManager != null) {
            return this.cacheManager.getMembers() != null && this.cacheManager.getMembers().size() > 1;
        }
        return false;
    }

    private int calculateGlobalConnections() {
        AtomicInteger connectionCount = new AtomicInteger();
        CompletableFuture results = SecurityActions.getClusterExecutor((EmbeddedCacheManager)this.cacheManager).submitConsumer((Function)new ConnectionAdderTask(this.threadNamePrefix), (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
            connectionCount.addAndGet((int)v);
        });
        try {
            results.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
        return connectionCount.get();
    }

    public Integer getNumberOfLocalConnections() {
        return this.acceptedChannels.size();
    }

    public Integer getNumberOfGlobalConnections() {
        if (this.needDistributedCalculation()) {
            return this.calculateGlobalConnections();
        }
        return this.getNumberOfLocalConnections();
    }

    @ProtoTypeId(value=6501)
    public static class ConnectionAdderTask
    implements Function<EmbeddedCacheManager, Integer> {
        @ProtoField(value=1)
        final String serverName;

        @ProtoFactory
        ConnectionAdderTask(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public Integer apply(EmbeddedCacheManager embeddedCacheManager) {
            ProtocolServer protocolServer = (ProtocolServer)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)embeddedCacheManager).getComponent(ProtocolServer.class, this.serverName);
            if (protocolServer == null) {
                return 0;
            }
            Transport transport = protocolServer.getTransport();
            return transport == null ? 0 : transport.getNumberOfLocalConnections();
        }
    }
}

