/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.json;

import java.util.Map;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;

public class JsonQueryRequest
implements JsonSerialization {
    private static final int DEFAULT_OFFSET = 0;
    private static final int DEFAULT_MAX_RESULTS = 10;
    private final String query;
    private final Integer startOffset;
    private final Integer maxResults;
    private Integer hitCountAccuracy;

    public JsonQueryRequest(String query, Integer startOffset, Integer maxResults, Integer hitCountAccuracy) {
        this.query = query;
        this.startOffset = startOffset == null ? 0 : startOffset;
        this.maxResults = maxResults == null ? 10 : maxResults;
        this.hitCountAccuracy = hitCountAccuracy;
    }

    public String getQuery() {
        return this.query;
    }

    public Integer getStartOffset() {
        return this.startOffset;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Integer getHitCountAccuracy() {
        return this.hitCountAccuracy;
    }

    public void setDefaultHitCountAccuracy(int defaultHitCountAccuracy) {
        if (this.hitCountAccuracy == null) {
            this.hitCountAccuracy = defaultHitCountAccuracy;
        }
    }

    public Json toJson() {
        throw new UnsupportedOperationException();
    }

    public static JsonQueryRequest fromJson(String json) {
        Map properties = Json.read((String)json).asJsonMap();
        Json queryValue = (Json)properties.get("query");
        Json offsetValue = (Json)properties.get("offset");
        Json maxResultsValue = (Json)properties.get("max_results");
        Json hitCountAccuracyValue = (Json)properties.get("hit_count_accuracy");
        String query = queryValue != null ? queryValue.asString() : null;
        Integer offset = offsetValue != null ? Integer.valueOf(offsetValue.asInteger()) : null;
        Integer maxResults = maxResultsValue != null ? Integer.valueOf(maxResultsValue.asInteger()) : null;
        Integer hitCountAccuracy = hitCountAccuracyValue != null ? Integer.valueOf(hitCountAccuracyValue.asInteger()) : null;
        return new JsonQueryRequest(query, offset, maxResults, hitCountAccuracy);
    }
}

