/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl.mapping.reference;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.server.core.query.impl.indexing.IndexingMetadata;
import org.infinispan.server.core.query.impl.indexing.search5.Search5MetadataCreator;
import org.infinispan.server.core.query.impl.mapping.reference.MessageReferenceProvider;

public final class GlobalReferenceHolder {
    private final Map<String, MessageReferenceProvider> messageReferenceProviders = new HashMap<String, MessageReferenceProvider>();
    private final Set<RootMessageInfo> rootMessages = new LinkedHashSet<RootMessageInfo>();
    private final Map<String, Descriptor> rootDescriptors = new HashMap<String, Descriptor>();
    private final Map<String, Descriptor> notRootDescriptors = new HashMap<String, Descriptor>();

    public GlobalReferenceHolder(Map<String, GenericDescriptor> descriptors) {
        HashSet<Descriptor> messageTypes = new HashSet<Descriptor>();
        HashSet nestedDescriptors = new HashSet();
        for (Map.Entry<String, GenericDescriptor> entry : descriptors.entrySet()) {
            GenericDescriptor genericDescriptor = entry.getValue();
            if (!(genericDescriptor instanceof Descriptor)) continue;
            Descriptor descriptor = (Descriptor)genericDescriptor;
            MessageReferenceProvider messageReferenceProvider = new MessageReferenceProvider(descriptor);
            if (messageReferenceProvider.isEmpty()) {
                this.notRootDescriptors.put(descriptor.getFullName(), descriptor);
                continue;
            }
            this.messageReferenceProviders.put(entry.getKey(), messageReferenceProvider);
            messageTypes.add(descriptor);
            nestedDescriptors.addAll(descriptor.getNestedTypes());
        }
        messageTypes.removeAll(nestedDescriptors);
        for (Descriptor descriptor : messageTypes) {
            this.rootMessages.add(new RootMessageInfo(descriptor));
            this.rootDescriptors.put(descriptor.getFullName(), descriptor);
        }
    }

    public Map<String, MessageReferenceProvider> getMessageReferenceProviders() {
        return this.messageReferenceProviders;
    }

    public Set<RootMessageInfo> getRootMessages() {
        return this.rootMessages;
    }

    public Descriptor getDescriptor(String fullName) {
        return this.rootDescriptors.get(fullName);
    }

    public MessageReferenceProvider messageReferenceProvider(String fullName) {
        return this.messageReferenceProviders.get(fullName);
    }

    public boolean hasKeyMapping(String fullName) {
        MessageReferenceProvider messageReferenceProvider = this.messageReferenceProvider(fullName);
        if (messageReferenceProvider == null) {
            return false;
        }
        return messageReferenceProvider.keyMessageName() != null;
    }

    public String toString() {
        return this.messageReferenceProviders.toString();
    }

    public MessageReferenceProvider messageProviderForEmbeddedType(MessageReferenceProvider.Embedded embedded) {
        String typeFullName = embedded.getTypeFullName();
        this.messageReferenceProviders.computeIfAbsent(typeFullName, key -> {
            Descriptor descriptor = this.notRootDescriptors.get(typeFullName);
            IndexingMetadata indexingMetadata = Search5MetadataCreator.createForEmbeddedType(descriptor);
            return new MessageReferenceProvider(descriptor, indexingMetadata);
        });
        MessageReferenceProvider provider = this.messageReferenceProviders.get(typeFullName);
        embedded.indexingMetadata(provider.indexingMetadata());
        return provider;
    }

    public static final class RootMessageInfo {
        private final String fullName;
        private final String indexName;

        private RootMessageInfo(Descriptor descriptor) {
            IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(descriptor, "Indexed");
            this.fullName = descriptor.getFullName();
            this.indexName = indexingMetadata.indexName() != null ? indexingMetadata.indexName() : this.fullName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }
}

