/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.factories;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.ThreadGroups;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.threads.NonBlockingThreadPoolExecutorFactory;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.NonRecursiveEventLoopGroup;

@DefaultFactoryFor(classes={EventLoopGroup.class})
public class NettyEventLoopFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = Log.getLog(NettyEventLoopFactory.class);

    public Object construct(String componentName) {
        ThreadPoolExecutorFactory tpef;
        ThreadFactory threadFactory = this.globalConfiguration.nonBlockingThreadPool().threadFactory();
        if (threadFactory == null) {
            threadFactory = new DefaultThreadFactory(KnownComponentNames.shortened((String)"org.infinispan.executors.non-blocking") + "-" + this.globalConfiguration.transport().nodeName(), true, KnownComponentNames.getDefaultThreadPrio((String)"org.infinispan.executors.non-blocking"), (ThreadGroup)ThreadGroups.NON_BLOCKING_GROUP);
        } else if (!NettyEventLoopFactory.isNettyThreadFactory(threadFactory)) {
            log.useNettyThreadFactory(threadFactory.getClass());
        }
        if (threadFactory instanceof org.infinispan.factories.threads.DefaultThreadFactory) {
            ((org.infinispan.factories.threads.DefaultThreadFactory)threadFactory).useVirtualThread(false);
        }
        int threadAmount = (tpef = this.globalConfiguration.nonBlockingThreadPool().threadPoolFactory()) instanceof NonBlockingThreadPoolExecutorFactory ? ((NonBlockingThreadPoolExecutorFactory)tpef).maxThreads() : KnownComponentNames.getDefaultThreads((String)"org.infinispan.executors.non-blocking");
        return new NonRecursiveEventLoopGroup(NettyTransport.buildEventLoop(threadAmount, threadFactory, "non-blocking-thread-netty"));
    }

    private static boolean isNettyThreadFactory(ThreadFactory tf) {
        return tf instanceof DefaultThreadFactory;
    }
}

