/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.telemetry.jfr;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.sdk.trace.internal.data.ExceptionEventData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.StackTrace;
import org.infinispan.commons.util.ByRef;

public final class JfrSpanProcessor
implements SpanProcessor {
    private final Map<SpanContext, JfrSpan> events = new ConcurrentHashMap<SpanContext, JfrSpan>();
    private volatile boolean closed;

    public void onStart(Context parentContext, ReadWriteSpan span) {
        if (this.closed || !span.getSpanContext().isValid()) {
            return;
        }
        JfrSpan event = JfrSpan.from((ReadableSpan)span);
        if (event.isEnabled()) {
            event.begin();
            this.events.put(span.getSpanContext(), event);
        }
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
        JfrSpan event = this.events.remove(span.getSpanContext());
        if (this.closed || event == null || !event.shouldCommit()) {
            return;
        }
        event.updateStatus(span.toSpanData());
        event.end();
        event.commit();
    }

    public boolean isEndRequired() {
        return true;
    }

    public CompletableResultCode shutdown() {
        this.closed = true;
        this.events.clear();
        return CompletableResultCode.ofSuccess();
    }

    @Label(value="JFR Span")
    @Description(value="Infinispan Tracing Events")
    @Category(value={"infinispan-jfr-span"})
    @StackTrace(value=false)
    private static final class JfrSpan
    extends Event {
        public final String node;
        public final String category;
        public final String cache;
        public final String operation;
        public final String trace;
        public final String span;
        public final String parent;
        public final String kind;
        public String status;
        @Label(value="status description")
        public String statusDescription;
        public String throwable;

        private JfrSpan(String node, String category, String cache, String operation, String trace, String span, String parent, String kind) {
            this.node = node;
            this.category = category;
            this.cache = cache;
            this.operation = operation;
            this.trace = trace;
            this.span = span;
            this.parent = parent;
            this.kind = kind;
        }

        public static JfrSpan from(ReadableSpan span) {
            SpanData sd = span.toSpanData();
            ByRef node = new ByRef(null);
            ByRef category = new ByRef(null);
            ByRef cache = new ByRef(null);
            sd.getAttributes().forEach((attr, value) -> {
                switch (attr.getKey()) {
                    case "server.address": {
                        node.set((Object)String.valueOf(value));
                        break;
                    }
                    case "category": {
                        category.set((Object)String.valueOf(value));
                        break;
                    }
                    case "cache": {
                        cache.set((Object)String.valueOf(value));
                    }
                }
            });
            SpanContext ctx = span.getSpanContext();
            return new JfrSpan((String)node.get(), (String)category.get(), (String)cache.get(), span.getName(), ctx.getTraceId(), ctx.getSpanId(), span.getParentSpanContext().getSpanId(), span.getKind().name());
        }

        public void updateStatus(SpanData span) {
            StatusData spanStatus = span.getStatus();
            for (EventData event : span.getEvents()) {
                if (!(event instanceof ExceptionEventData)) continue;
                ExceptionEventData eed = (ExceptionEventData)event;
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    PrintStream ps = new PrintStream(baos);
                    eed.getException().printStackTrace(ps);
                    this.throwable = baos.toString();
                    break;
                }
                catch (IOException iOException) {
                }
            }
            this.status = spanStatus.getStatusCode().name();
            this.statusDescription = spanStatus.getDescription();
        }
    }
}

