/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl.filter;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.core.impl.continuous.IckleContinuousQueryCacheEventFilterConverter;
import org.infinispan.query.objectfilter.Matcher;
import org.infinispan.query.objectfilter.ObjectFilter;
import org.infinispan.query.remote.client.impl.ContinuousQueryResult;
import org.infinispan.server.core.query.impl.RemoteQueryManager;

@ProtoTypeId(value=4405)
public final class IckleContinuousQueryProtobufCacheEventFilterConverter
extends IckleContinuousQueryCacheEventFilterConverter<Object, Object, Object> {
    private RemoteQueryManager remoteQueryManager;

    IckleContinuousQueryProtobufCacheEventFilterConverter(String queryString, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        super(queryString, namedParameters, matcherImplClass);
    }

    @ProtoFactory
    IckleContinuousQueryProtobufCacheEventFilterConverter(String queryString, MarshallableMap<String, Object> wrappedNamedParameters, Class<? extends Matcher> matcherImplClass) {
        super(queryString, wrappedNamedParameters, matcherImplClass);
    }

    protected void injectDependencies(Cache<?, ?> cache) {
        this.remoteQueryManager = (RemoteQueryManager)ComponentRegistry.componentOf(cache, RemoteQueryManager.class);
        this.matcherImplClass = this.remoteQueryManager.getMatcherClass(MediaType.APPLICATION_PROTOSTREAM);
        super.injectDependencies(cache);
    }

    public Object filterAndConvert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
        ObjectFilter.FilterResult f2;
        if (eventType.isExpired()) {
            oldValue = newValue;
            newValue = null;
        }
        ObjectFilter objectFilter = this.getObjectFilter();
        ObjectFilter.FilterResult f1 = oldValue == null ? null : objectFilter.filter(key, oldValue, (Object)oldMetadata);
        ObjectFilter.FilterResult filterResult = f2 = newValue == null ? null : objectFilter.filter(key, newValue, (Object)newMetadata);
        if (f1 == null && f2 != null) {
            return this.makeFilterResult(ContinuousQueryResult.ResultType.JOINING, key, f2.getProjection() == null ? newValue : null, f2.getProjection());
        }
        if (f1 != null && f2 == null) {
            return this.makeFilterResult(ContinuousQueryResult.ResultType.LEAVING, key, null, null);
        }
        return null;
    }

    private Object makeFilterResult(ContinuousQueryResult.ResultType resultType, Object key, Object value, Object[] projection) {
        key = this.remoteQueryManager.convertKey(key, MediaType.APPLICATION_PROTOSTREAM);
        if (value != null) {
            value = this.remoteQueryManager.convertValue(value, MediaType.APPLICATION_PROTOSTREAM);
        }
        ContinuousQueryResult result = new ContinuousQueryResult(resultType, (byte[])key, (byte[])value, projection);
        return this.remoteQueryManager.encodeFilterResult(result);
    }

    public String toString() {
        return "IckleContinuousQueryProtobufCacheEventFilterConverter{queryString='" + this.queryString + "'}";
    }
}

