/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.server.core.query.impl.QuerySerializer;
import org.infinispan.server.core.query.impl.RemoteQueryResult;
import org.infinispan.server.core.query.json.EntityProjection;
import org.infinispan.server.core.query.json.Hit;
import org.infinispan.server.core.query.json.JsonProjection;
import org.infinispan.server.core.query.json.JsonQueryResponse;
import org.infinispan.server.core.query.json.JsonQueryResult;
import org.infinispan.server.core.query.json.ProjectedJsonResult;

public class JsonQuerySerializer
implements QuerySerializer<JsonQueryResponse> {
    private final MediaType storageMediaTye;
    private final Transcoder transcoderFromStorage;

    public JsonQuerySerializer(MediaType storageMediaTye, Transcoder transcoderFromStorage) {
        this.storageMediaTye = storageMediaTye;
        this.transcoderFromStorage = transcoderFromStorage;
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest, MediaType mediaType) {
        return QueryRequest.fromJson((Json)Json.read((String)new String(queryRequest, mediaType.getCharset())));
    }

    @Override
    public JsonQueryResponse createQueryResponse(RemoteQueryResult remoteQueryResult) {
        JsonQueryResponse response;
        int hitCount = remoteQueryResult.hitCount();
        boolean hitCountExact = remoteQueryResult.hitCountExact();
        String[] projections = remoteQueryResult.getProjections();
        if (projections == null) {
            List results = remoteQueryResult.getResults().stream().map(o -> this.transcoderFromStorage.transcode(o, this.storageMediaTye, MediaType.APPLICATION_JSON)).collect(Collectors.toList());
            List<Hit> hits = results.stream().map(Hit::new).collect(Collectors.toList());
            response = new JsonQueryResult(hits, hitCount, hitCountExact);
        } else {
            ArrayList<JsonProjection> hits = new ArrayList<JsonProjection>(projections.length);
            for (Object v : remoteQueryResult.getResults()) {
                Object[] result = (Object[])v;
                HashMap<String, Object> p = new HashMap<String, Object>();
                for (int i = 0; i < projections.length; ++i) {
                    String projectionKey = projections[i];
                    Object value = result[i];
                    if ("__HSearch_This".equals(projectionKey) && value instanceof WrappedMessage) {
                        value = new EntityProjection(this.transcoderFromStorage.transcode(((WrappedMessage)value).getValue(), this.storageMediaTye, MediaType.APPLICATION_JSON));
                        p.put("*", value);
                        continue;
                    }
                    if ("__ISPN_Score".equals(projectionKey)) {
                        p.put("score()", value);
                        continue;
                    }
                    if ("__ISPN_Version".equals(projectionKey)) {
                        p.put("version()", value);
                        continue;
                    }
                    p.put(projectionKey, value);
                }
                hits.add(new JsonProjection(p));
            }
            response = new ProjectedJsonResult(hitCount, hitCountExact, hits);
        }
        return response;
    }

    @Override
    public byte[] encodeQueryResponse(Object queryResponse, MediaType destinationType) {
        return ((JsonQueryResponse)queryResponse).toJson().toString().getBytes(destinationType.getCharset());
    }
}

