/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.utils.DelegatingEventLoopGroup;

@Scope(value=Scopes.GLOBAL)
public class NonRecursiveEventLoopGroup
extends DelegatingEventLoopGroup {
    private static final Log log = Log.getLog(NonRecursiveEventLoopGroup.class);
    private final MultithreadEventLoopGroup eventLoopGroup;

    public NonRecursiveEventLoopGroup(MultithreadEventLoopGroup eventLoopGroup) {
        int executors = eventLoopGroup.executorCount();
        if (executors < 2) {
            throw new IllegalArgumentException("Provided multi threaded event loop group must have at least 2 executors, only has " + executors);
        }
        this.eventLoopGroup = eventLoopGroup;
    }

    @Override
    protected EventLoopGroup delegate() {
        return this.eventLoopGroup;
    }

    @Override
    public void execute(Runnable command) {
        this.getExecutorNotInEventLoop().execute(command);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.getExecutorNotInEventLoop().submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.getExecutorNotInEventLoop().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.getExecutorNotInEventLoop().submit(task, result);
    }

    private EventExecutor getExecutorNotInEventLoop() {
        EventLoop eventExecutor;
        while ((eventExecutor = this.eventLoopGroup.next()).inEventLoop()) {
            log.tracef("Skipped submitting task to %s as it is the current event loop - trying another", eventExecutor);
        }
        return eventExecutor;
    }

    @Stop
    public void shutdownGracefullyAndWait() {
        try {
            this.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS).await(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.debug("Interrupted while waiting for event loop group to shut down");
            Thread.currentThread().interrupt();
        }
    }
}

