/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.server.core.query.impl.RemoteQueryManager;
import org.infinispan.server.core.query.impl.SecurityActions;
import org.infinispan.server.core.query.impl.logging.Log;

public final class QueryFacadeImpl
implements QueryFacade {
    private static final Log log = Log.getLog(QueryFacadeImpl.class);

    @Override
    public byte[] query(AdvancedCache<?, ?> cache, byte[] query) {
        RemoteQueryManager remoteQueryManager;
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
        if ((remoteQueryManager = SecurityActions.getRemoteQueryManager(cache)).getQueryEngine(cache) == null) {
            throw log.queryingNotEnabled(cache.getName());
        }
        try {
            MediaType requestMediaType = cache.getValueDataConversion().getRequestMediaType();
            QueryRequest request = remoteQueryManager.decodeQueryRequest(query, requestMediaType);
            Long startOffset = request.getStartOffset();
            Integer maxResults = request.getMaxResults();
            int hitCountAccuracy = request.hitCountAccuracy();
            boolean local = request.isLocal();
            return remoteQueryManager.executeQuery(request.getQueryString(), request.getNamedParametersMap(), startOffset, maxResults, hitCountAccuracy, cache, requestMediaType, local);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debugf(e, "Error executing remote query : %s", e.getMessage());
            }
            throw e;
        }
    }
}

