/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.query.BaseQuery;
import org.infinispan.encoding.DataConversion;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.server.core.query.impl.QuerySerializer;
import org.infinispan.server.core.query.impl.QuerySerializers;
import org.infinispan.server.core.query.impl.RemoteQueryManager;
import org.infinispan.server.core.query.impl.RemoteQueryResult;
import org.infinispan.server.core.query.impl.logging.Log;

@Scope(value=Scopes.NAMED_CACHE)
abstract class BaseRemoteQueryManager
implements RemoteQueryManager {
    private static final Log log = Log.getLog(BaseRemoteQueryManager.class);
    final AdvancedCache<?, ?> cache;
    private final QuerySerializers querySerializers;
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final boolean cacheQueryable;
    private final MediaType storageType;
    private final boolean unknownMediaType;
    @Inject
    protected EncoderRegistry encoderRegistry;
    @Inject
    protected LocalQueryStatistics queryStatistics;

    BaseRemoteQueryManager(AdvancedCache<?, ?> cache, QuerySerializers querySerializers, ComponentRegistry cr) {
        this.cache = cache;
        this.querySerializers = querySerializers;
        this.keyDataConversion = cache.getKeyDataConversion();
        this.valueDataConversion = cache.getValueDataConversion();
        StorageConfigurationManager storageConfigurationManager = (StorageConfigurationManager)cr.getComponent(StorageConfigurationManager.class);
        this.storageType = storageConfigurationManager.getValueStorageMediaType();
        this.cacheQueryable = storageConfigurationManager.isQueryable();
        this.unknownMediaType = this.storageType.match(MediaType.APPLICATION_UNKNOWN);
    }

    @Override
    public byte[] executeDeleteByQuery(String queryString, Map<String, Object> namedParametersMap, AdvancedCache<?, ?> cache, MediaType outputFormat, boolean isLocal) {
        QueryResultWithProjection resultWithProjection = this.localQuery(queryString, namedParametersMap, null, null, null, cache, isLocal);
        QueryResult<Object> queryResult = resultWithProjection.queryResult;
        String[] projection = resultWithProjection.projection;
        QuerySerializer<?> querySerializer = this.querySerializers.getSerializer(outputFormat);
        RemoteQueryResult remoteQueryResult = new RemoteQueryResult(projection, queryResult.count().value(), queryResult.count().exact(), queryResult.list());
        Object response = querySerializer.createQueryResponse(remoteQueryResult);
        return querySerializer.encodeQueryResponse(response, outputFormat);
    }

    @Override
    public byte[] executeQuery(String queryString, Map<String, Object> namedParametersMap, Number offset, Number maxResults, Integer hitCountAccuracy, AdvancedCache<?, ?> cache, MediaType outputFormat, boolean isLocal) {
        QueryResultWithProjection resultWithProjection = this.localQuery(queryString, namedParametersMap, offset, maxResults, hitCountAccuracy, cache, isLocal);
        QueryResult<Object> queryResult = resultWithProjection.queryResult;
        String[] projection = resultWithProjection.projection;
        QuerySerializer<?> querySerializer = this.querySerializers.getSerializer(outputFormat);
        RemoteQueryResult remoteQueryResult = new RemoteQueryResult(projection, queryResult.count().value(), queryResult.count().exact(), queryResult.list());
        Object response = querySerializer.createQueryResponse(remoteQueryResult);
        return querySerializer.encodeQueryResponse(response, outputFormat);
    }

    @Override
    public QueryResultWithProjection localQuery(String queryString, Map<String, Object> namedParametersMap, Number offset, Number maxResults, Integer hitCountAccuracy, AdvancedCache<?, ?> cache, boolean isLocal) {
        if (this.unknownMediaType) {
            log.warnNoMediaType(cache.getName());
        } else if (!this.cacheQueryable) {
            throw log.cacheNotQueryable(cache.getName(), this.storageType.getTypeSubtype());
        }
        Query<Object> query = this.getQueryEngine(cache).makeQuery(queryString, namedParametersMap, offset, maxResults, hitCountAccuracy, isLocal);
        QueryResult execute = query.execute();
        return new QueryResultWithProjection((QueryResult<Object>)execute, ((BaseQuery)query).getProjection());
    }

    @Override
    public Object convertKey(Object key, MediaType destinationFormat) {
        return this.encoderRegistry.convert(key, this.keyDataConversion.getStorageMediaType(), destinationFormat);
    }

    @Override
    public Object convertValue(Object value, MediaType destinationFormat) {
        return this.encoderRegistry.convert(value, this.valueDataConversion.getStorageMediaType(), destinationFormat);
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest, MediaType requestType) {
        return this.querySerializers.getSerializer(requestType).decodeQueryRequest(queryRequest, requestType);
    }

    @Override
    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    @Override
    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    public record QueryResultWithProjection(QueryResult<Object> queryResult, String[] projection) {
    }
}

