/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.topology.PersistentUUIDManager;

public abstract class BaseServerManagement
implements ServerManagement {
    @Override
    public Json overviewReport() {
        DefaultCacheManager cacheManager = this.getCacheManager();
        GlobalComponentRegistry registry = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager);
        PersistentUUIDManager uuidManager = (PersistentUUIDManager)registry.getComponent(PersistentUUIDManager.class);
        Address nodeAddress = cacheManager.getAddress();
        Address coordinatorAddress = cacheManager.getCoordinator();
        String nodeId = nodeAddress == null ? null : uuidManager.getPersistentUuid(nodeAddress).toString();
        String coordinatorId = coordinatorAddress == null ? null : uuidManager.getPersistentUuid(coordinatorAddress).toString();
        HashSet cacheStores = new HashSet();
        HashSet encodings = new HashSet();
        CacheManagerInfo info = cacheManager.getCacheManagerInfo();
        Json cacheCardinalities = Json.array();
        Map cacheFeatures = info.getCacheNames().filter(name -> {
            int size;
            try {
                size = cacheManager.getCache(name).size();
            }
            catch (Throwable throwable) {
                return false;
            }
            cacheCardinalities.add(BaseServerManagement.cacheCardinality(size));
            return true;
        }).map(name -> SecurityActions.getCacheConfiguration((EmbeddedCacheManager)cacheManager, (String)name)).map(configuration -> {
            BaseServerManagement.collectCacheStores(cacheStores, configuration);
            BaseServerManagement.collectEncodings(encodings, configuration);
            return BaseServerManagement.cacheFeatures(configuration);
        }).sorted().collect(Collectors.toMap(s -> s, s -> 1, Integer::sum, LinkedHashMap::new));
        Json features = Json.object();
        for (Map.Entry feature : cacheFeatures.entrySet()) {
            features.set((String)feature.getKey(), feature.getValue());
        }
        Set cacheNames = cacheManager.getCacheNames();
        int protoSchemas = !cacheNames.contains("___protobuf_metadata") ? 0 : SecurityActions.getUnwrappedCache((EmbeddedCacheManager)cacheManager, (String)"___protobuf_metadata").size();
        ServerStateManager serverStateManager = this.getServerStateManager();
        Json clients = serverStateManager == null ? Json.nil() : serverStateManager.clientsReport();
        return Json.object((Object[])new Object[]{"version", "1.0.0"}).set("product-version", (Object)Version.getBrandVersion()).set("node-id", (Object)nodeId).set("coordinator-id", (Object)coordinatorId).set("cluster-size", (Object)info.getClusterSize()).set("sites", (Object)info.getSites().size()).set("relay-node", (Object)info.isRelayNode()).set("cache-cardinalities", cacheCardinalities).set("cache-features", features).set("cache-stores", cacheStores).set("proto-schemas", (Object)protoSchemas).set("used-encodings", encodings).set("clients", clients).set("security", this.securityOverviewReport());
    }

    private static void collectCacheStores(HashSet<String> cacheStores, Configuration configuration) {
        for (StoreConfiguration store : configuration.persistence().stores()) {
            if (!(store instanceof ConfigurationElement)) continue;
            String elementName = ((ConfigurationElement)store).elementName();
            cacheStores.add(elementName);
        }
    }

    private static void collectEncodings(HashSet<String> encodings, Configuration configuration) {
        MediaType valueDataType;
        MediaType keyMediaType;
        MediaType mediaType;
        EncodingConfiguration encoding = configuration.encoding();
        Attribute mediaTypeAttribute = encoding.attributes().attribute("media-type");
        if (mediaTypeAttribute != null && (mediaType = (MediaType)mediaTypeAttribute.get()) != null) {
            encodings.add(mediaType.toString());
        }
        if ((keyMediaType = encoding.keyDataType().mediaType()) != null) {
            encodings.add(keyMediaType.toString());
        }
        if ((valueDataType = encoding.valueDataType().mediaType()) != null) {
            encodings.add(valueDataType.toString());
        }
    }

    private static String cacheFeatures(Configuration configuration) {
        ArrayList<String> features = new ArrayList<String>(7);
        if (configuration.simpleCache()) {
            features.add("simpleCache");
        }
        if (configuration.transaction().transactionMode().isTransactional()) {
            features.add("transactional");
        }
        if (configuration.persistence().usingStores()) {
            features.add("persistence");
        }
        if (configuration.memory().whenFull().isEnabled()) {
            features.add("bounded");
        }
        if (configuration.security().authorization().enabled()) {
            features.add("secured");
        }
        if (configuration.indexing().enabled()) {
            features.add("indexed");
        }
        if (configuration.sites().hasBackups()) {
            features.add("hasRemoteBackup");
        }
        return features.isEmpty() ? "no-features" : String.join((CharSequence)"+", features);
    }

    private static Json cacheCardinality(int size) {
        return Json.make((Object)("" + "KMGTPEZ".charAt((int)(Math.log10(size + 1) / 3.0))));
    }
}

