/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl.mapping.reference;

import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.server.core.query.impl.indexing.SpatialFieldMapping;

public class SpatialReferenceProvider {
    private final String longitudeName;
    private final String latitudeName;
    private final String indexName;
    private final Searchable searchable;
    private final Projectable projectable;
    private final Aggregable aggregable;
    private final Sortable sortable;

    public SpatialReferenceProvider(SpatialFieldMapping spatialFieldMapping) {
        FieldDescriptor longitude = spatialFieldMapping.getLongitude();
        FieldDescriptor latitude = spatialFieldMapping.getLatitude();
        this.longitudeName = longitude == null ? spatialFieldMapping.fieldName() + ".longitude" : longitude.getName();
        this.latitudeName = latitude == null ? spatialFieldMapping.fieldName() + ".latitude" : latitude.getName();
        this.indexName = spatialFieldMapping.fieldName();
        this.projectable = spatialFieldMapping.projectable() ? Projectable.YES : Projectable.NO;
        this.searchable = Searchable.YES;
        this.aggregable = Aggregable.NO;
        this.sortable = spatialFieldMapping.sortable() ? Sortable.YES : Sortable.NO;
    }

    public String longitudeName() {
        return this.longitudeName;
    }

    public String latitudeName() {
        return this.latitudeName;
    }

    public String indexName() {
        return this.indexName;
    }

    public IndexFieldReference<GeoPoint> bind(IndexSchemaElement indexSchemaElement) {
        if (this.nothingToBind()) {
            return null;
        }
        return (IndexFieldReference)indexSchemaElement.field(this.indexName, f -> ((StandardIndexFieldTypeOptionsStep)((StandardIndexFieldTypeOptionsStep)f.asGeoPoint().searchable(this.searchable)).projectable(this.projectable)).aggregable(this.aggregable).sortable(this.sortable)).toReference();
    }

    public boolean nothingToBind() {
        return Searchable.NO.equals((Object)this.searchable) && Projectable.NO.equals((Object)this.projectable) && Aggregable.NO.equals((Object)this.aggregable) && Sortable.NO.equals((Object)this.sortable);
    }
}

