/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.AuthenticationConfiguration;
import org.infinispan.server.core.configuration.IpFilterConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;
import org.infinispan.server.core.logging.Log;

public abstract class ProtocolServerConfigurationBuilder<T extends ProtocolServerConfiguration<T, A>, S extends ProtocolServerConfigurationChildBuilder<T, S, A>, A extends AuthenticationConfiguration>
implements ProtocolServerConfigurationChildBuilder<T, S, A>,
Builder<T> {
    protected final AttributeSet attributes;
    protected final SslConfigurationBuilder<T, S, A> ssl;
    protected final IpFilterConfigurationBuilder<T, S, A> ipFilter;

    protected ProtocolServerConfigurationBuilder(int port, AttributeSet attributes) {
        this.attributes = attributes;
        this.ssl = new SslConfigurationBuilder(this);
        this.ipFilter = new IpFilterConfigurationBuilder(this);
        this.port(port);
    }

    @Override
    public S defaultCacheName(String defaultCacheName) {
        this.attributes.attribute(ProtocolServerConfiguration.DEFAULT_CACHE_NAME).set((Object)defaultCacheName);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S name(String name) {
        this.attributes.attribute(ProtocolServerConfiguration.NAME).set((Object)name);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    public String name() {
        return (String)this.attributes.attribute(ProtocolServerConfiguration.NAME).get();
    }

    @Override
    public S host(String host) {
        this.attributes.attribute(ProtocolServerConfiguration.HOST).set((Object)host);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    public String host() {
        return (String)this.attributes.attribute(ProtocolServerConfiguration.HOST).get();
    }

    @Override
    public S port(int port) {
        this.attributes.attribute(ProtocolServerConfiguration.PORT).set((Object)port);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    public int port() {
        return (Integer)this.attributes.attribute(ProtocolServerConfiguration.PORT).get();
    }

    @Override
    public S idleTimeout(int idleTimeout) {
        this.attributes.attribute(ProtocolServerConfiguration.IDLE_TIMEOUT).set((Object)idleTimeout);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S tcpNoDelay(boolean tcpNoDelay) {
        this.attributes.attribute(ProtocolServerConfiguration.TCP_NODELAY).set((Object)tcpNoDelay);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S tcpKeepAlive(boolean tcpKeepAlive) {
        this.attributes.attribute(ProtocolServerConfiguration.TCP_KEEPALIVE).set((Object)tcpKeepAlive);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S recvBufSize(int recvBufSize) {
        this.attributes.attribute(ProtocolServerConfiguration.RECV_BUF_SIZE).set((Object)recvBufSize);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S sendBufSize(int sendBufSize) {
        this.attributes.attribute(ProtocolServerConfiguration.SEND_BUF_SIZE).set((Object)sendBufSize);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public SslConfigurationBuilder ssl() {
        return this.ssl;
    }

    @Override
    public IpFilterConfigurationBuilder<T, S, A> ipFilter() {
        return this.ipFilter;
    }

    @Override
    public S ioThreads(int ioThreads) {
        this.attributes.attribute(ProtocolServerConfiguration.IO_THREADS).set((Object)ioThreads);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S startTransport(boolean startTransport) {
        this.attributes.attribute(ProtocolServerConfiguration.START_TRANSPORT).set((Object)startTransport);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    public boolean startTransport() {
        return (Boolean)this.attributes.attribute(ProtocolServerConfiguration.START_TRANSPORT).get();
    }

    @Override
    public S adminOperationsHandler(AdminOperationsHandler handler) {
        this.attributes.attribute(ProtocolServerConfiguration.ADMIN_OPERATION_HANDLER).set((Object)handler);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    @Override
    public S socketBinding(String name) {
        this.attributes.attribute(ProtocolServerConfiguration.SOCKET_BINDING).set((Object)name);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    public String socketBinding() {
        return (String)this.attributes.attribute(ProtocolServerConfiguration.SOCKET_BINDING).get();
    }

    @Override
    public S implicitConnector(boolean implicitConnector) {
        this.attributes.attribute(ProtocolServerConfiguration.IMPLICIT_CONNECTOR).set((Object)implicitConnector);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    public boolean implicitConnector() {
        return (Boolean)this.attributes.attribute(ProtocolServerConfiguration.IMPLICIT_CONNECTOR).get();
    }

    @Override
    public S maxContentLength(String maxContentLength) {
        this.attributes.attribute(ProtocolServerConfiguration.MAX_CONTENT_LENGTH).set((Object)maxContentLength);
        return (S)((ProtocolServerConfigurationChildBuilder)this.self());
    }

    public String maxContentLength() {
        return (String)this.attributes.attribute(ProtocolServerConfiguration.MAX_CONTENT_LENGTH).get();
    }

    public void validate() {
        this.authentication().validate();
        this.ssl.validate();
        if ((Integer)this.attributes.attribute(ProtocolServerConfiguration.IDLE_TIMEOUT).get() < -1) {
            throw Log.CONFIG.illegalIdleTimeout((Integer)this.attributes.attribute(ProtocolServerConfiguration.IDLE_TIMEOUT).get());
        }
        if ((Integer)this.attributes.attribute(ProtocolServerConfiguration.SEND_BUF_SIZE).get() < 0) {
            throw Log.CONFIG.illegalSendBufferSize((Integer)this.attributes.attribute(ProtocolServerConfiguration.SEND_BUF_SIZE).get());
        }
        if ((Integer)this.attributes.attribute(ProtocolServerConfiguration.RECV_BUF_SIZE).get() < 0) {
            throw Log.CONFIG.illegalReceiveBufferSize((Integer)this.attributes.attribute(ProtocolServerConfiguration.RECV_BUF_SIZE).get());
        }
        if ((Integer)this.attributes.attribute(ProtocolServerConfiguration.IO_THREADS).get() < 0) {
            throw Log.CONFIG.illegalIOThreads((Integer)this.attributes.attribute(ProtocolServerConfiguration.IO_THREADS).get());
        }
    }

    public Builder<?> read(T template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.authentication().read(((ProtocolServerConfiguration)((Object)template)).authentication(), combine);
        this.ssl.read(((ProtocolServerConfiguration)((Object)template)).ssl(), combine);
        this.ipFilter.read(((ProtocolServerConfiguration)((Object)template)).ipFilter(), combine);
        return this;
    }
}

