/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.Executor;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheInitializeInboundAdapter
extends ChannelInboundHandlerAdapter {
    private static final Log log = (Log)LogFactory.getLog(CacheInitializeInboundAdapter.class, Log.class);
    public static final Object CACHE_INITIALIZE_EVENT = new Object();
    private final AbstractProtocolServer<?> server;

    public CacheInitializeInboundAdapter(AbstractProtocolServer<?> server) {
        this.server = server;
    }

    private void initializeHandlerState(ChannelHandlerContext ctx, Runnable done) {
        if (this.server.isDefaultCacheInitialized() && this.server.isDefaultCacheRunning()) {
            done.run();
            this.remove(ctx);
            return;
        }
        ctx.channel().config().setAutoRead(false);
        this.server.initializeDefaultCache().whenCompleteAsync((ignore, t) -> {
            if (t != null) {
                log.errorf((Throwable)t, "Failed to initialize default cache %s on channel %s", this.server.getName(), ctx.channel());
                ctx.close();
                return;
            }
            ctx.channel().config().setAutoRead(true);
            done.run();
            this.remove(ctx);
        }, (Executor)ctx.channel().eventLoop());
    }

    private void remove(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.server.isDefaultCacheInitialized() && this.server.isDefaultCacheRunning()) {
            super.channelActive(ctx);
            this.remove(ctx);
            return;
        }
        this.initializeHandlerState(ctx, () -> ((ChannelHandlerContext)ctx).fireChannelActive());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == CACHE_INITIALIZE_EVENT) {
            this.initializeHandlerState(ctx, () -> ctx.fireUserEventTriggered(CACHE_INITIALIZE_EVENT));
            return;
        }
        super.userEventTriggered(ctx, evt);
    }
}

