/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl.mapping.reference;

import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeFactoryImpl;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFinalStep;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.VectorFieldTypeOptionsStep;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.server.core.query.impl.indexing.FieldMapping;
import org.infinispan.server.core.query.impl.logging.Log;

public class FieldReferenceProvider {
    private static final Log log = (Log)LogFactory.getLog(FieldReferenceProvider.class, Log.class);
    public static final String INFINISPAN_COMMON_TYPES_GROUP = "org.infinispan.protostream.commons.";
    public static final String BIG_INTEGER_COMMON_TYPE = "org.infinispan.protostream.commons.BigInteger";
    public static final String BIG_DECIMAL_COMMON_TYPE = "org.infinispan.protostream.commons.BigDecimal";
    static final String[] COMMON_MESSAGE_TYPES = new String[]{"org.infinispan.protostream.commons.BigInteger", "org.infinispan.protostream.commons.BigDecimal"};
    private final String name;
    private final Type type;
    private final String typeName;
    private final boolean repeated;
    private final String indexName;
    private final Searchable searchable;
    private final Projectable projectable;
    private final Aggregable aggregable;
    private final Sortable sortable;
    private final String analyzer;
    private final String normalizer;
    private final Object indexNullAs;
    private final Norms norms;
    private final String searchAnalyzer;
    private final TermVector termVector;
    private final Integer decimalScale;
    private final Integer dimension;
    private final VectorSimilarity similarity;
    private final Integer beamWidth;
    private final Integer maxConnection;

    public FieldReferenceProvider(FieldDescriptor fieldDescriptor, FieldMapping fieldMapping) {
        this.name = fieldDescriptor.getName();
        this.type = fieldDescriptor.getType();
        this.typeName = fieldDescriptor.getTypeName();
        this.repeated = fieldDescriptor.isRepeated();
        this.indexName = fieldMapping.name();
        this.searchable = fieldMapping.searchable() ? Searchable.YES : Searchable.NO;
        this.projectable = fieldMapping.projectable() ? Projectable.YES : Projectable.NO;
        this.aggregable = fieldMapping.aggregable() ? Aggregable.YES : Aggregable.NO;
        this.sortable = fieldMapping.sortable() ? Sortable.YES : Sortable.NO;
        this.analyzer = fieldMapping.analyzer();
        this.normalizer = fieldMapping.normalizer();
        this.indexNullAs = fieldMapping.parseIndexNullAs();
        this.norms = fieldMapping.norms() == null ? null : (fieldMapping.norms() != false ? Norms.YES : Norms.NO);
        this.searchAnalyzer = fieldMapping.searchAnalyzer();
        this.termVector = FieldReferenceProvider.termVector(fieldMapping.termVector());
        this.decimalScale = fieldMapping.decimalScale();
        this.dimension = fieldMapping.dimension();
        this.similarity = FieldReferenceProvider.vectorSimilarity(fieldMapping.similarity());
        this.beamWidth = fieldMapping.beamWidth();
        this.maxConnection = fieldMapping.maxConnection();
    }

    private static TermVector termVector(org.infinispan.api.annotations.indexing.option.TermVector termVector) {
        if (termVector == null) {
            return null;
        }
        switch (termVector) {
            case YES: {
                return TermVector.YES;
            }
            case NO: {
                return TermVector.NO;
            }
            case WITH_POSITIONS: {
                return TermVector.WITH_POSITIONS;
            }
            case WITH_OFFSETS: {
                return TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS_OFFSETS: {
                return TermVector.WITH_POSITIONS_OFFSETS;
            }
            case WITH_POSITIONS_PAYLOADS: {
                return TermVector.WITH_POSITIONS_PAYLOADS;
            }
            case WITH_POSITIONS_OFFSETS_PAYLOADS: {
                return TermVector.WITH_POSITIONS_OFFSETS_PAYLOADS;
            }
        }
        return null;
    }

    private static VectorSimilarity vectorSimilarity(org.infinispan.api.annotations.indexing.option.VectorSimilarity vectorSimilarity) {
        if (vectorSimilarity == null) {
            return null;
        }
        switch (vectorSimilarity) {
            case L2: {
                return VectorSimilarity.L2;
            }
            case INNER_PRODUCT: {
                return VectorSimilarity.DOT_PRODUCT;
            }
            case MAX_INNER_PRODUCT: {
                return VectorSimilarity.MAX_INNER_PRODUCT;
            }
            case COSINE: {
                return VectorSimilarity.COSINE;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IndexFieldReference<Object> bind(IndexSchemaElement indexSchemaElement) {
        if (this.nothingToBind()) {
            return null;
        }
        IndexSchemaFieldOptionsStep step = indexSchemaElement.field(this.indexName, this::bind);
        if (this.repeated && this.dimension == null) {
            step.multiValued();
        }
        return (IndexFieldReference)step.toReference();
    }

    public boolean nothingToBind() {
        return Searchable.NO.equals((Object)this.searchable) && Projectable.NO.equals((Object)this.projectable) && Aggregable.NO.equals((Object)this.aggregable) && Sortable.NO.equals((Object)this.sortable);
    }

    private <F> IndexFieldTypeFinalStep<F> bind(IndexFieldTypeFactory typeFactory) {
        if (this.dimension != null) {
            return this.bindVector(typeFactory);
        }
        StandardIndexFieldTypeOptionsStep<?, ?> optionsStep = this.bindType(typeFactory);
        ((StandardIndexFieldTypeOptionsStep)((StandardIndexFieldTypeOptionsStep)optionsStep.searchable(this.searchable)).sortable(this.sortable).projectable(this.projectable)).aggregable(this.aggregable);
        if (this.indexNullAs != null) {
            optionsStep.indexNullAs(this.indexNullAs);
        }
        return optionsStep;
    }

    private <F> IndexFieldTypeFinalStep<F> bindVector(IndexFieldTypeFactory typeFactory) {
        VectorFieldTypeOptionsStep step = switch (this.type.getJavaType()) {
            case JavaType.BYTE_STRING -> typeFactory.asByteVector();
            case JavaType.FLOAT -> typeFactory.asFloatVector();
            default -> throw log.wrongTypeForVector(this.type.toString(), this.name, JavaType.BYTE_STRING, JavaType.FLOAT);
        };
        step.dimension(this.dimension.intValue());
        step.vectorSimilarity(this.similarity);
        step.efConstruction(this.beamWidth.intValue());
        step.m(this.maxConnection.intValue());
        step.searchable(this.searchable);
        step.projectable(this.projectable);
        if (this.indexNullAs != null) {
            step.indexNullAs(this.indexNullAs);
        }
        return step;
    }

    private StandardIndexFieldTypeOptionsStep<?, ?> bindType(IndexFieldTypeFactory typeFactory) {
        switch (this.type.getJavaType()) {
            case ENUM: 
            case INT: {
                return typeFactory.asInteger();
            }
            case LONG: {
                return typeFactory.asLong();
            }
            case FLOAT: {
                return typeFactory.asFloat();
            }
            case DOUBLE: {
                return typeFactory.asDouble();
            }
            case BOOLEAN: {
                return typeFactory.asBoolean();
            }
            case STRING: {
                StringIndexFieldTypeOptionsStep step = typeFactory.asString();
                this.bindStringTypeOptions(typeFactory, step);
                return step;
            }
            case BYTE_STRING: {
                return typeFactory.asString();
            }
            case MESSAGE: {
                return this.bindCommonMessageType(typeFactory);
            }
        }
        throw log.fieldTypeNotIndexable(this.type.toString(), this.name);
    }

    private StandardIndexFieldTypeOptionsStep<?, ?> bindCommonMessageType(IndexFieldTypeFactory typeFactory) {
        if (BIG_INTEGER_COMMON_TYPE.equals(this.typeName)) {
            ScaledNumberIndexFieldTypeOptionsStep step = typeFactory.asBigInteger();
            this.bindScaledNumberTypeOptions(step);
            return step;
        }
        if (BIG_DECIMAL_COMMON_TYPE.equals(this.typeName)) {
            ScaledNumberIndexFieldTypeOptionsStep step = typeFactory.asBigDecimal();
            this.bindScaledNumberTypeOptions(step);
            return step;
        }
        throw log.fieldTypeNotIndexable(this.typeName, this.name);
    }

    private void bindScaledNumberTypeOptions(ScaledNumberIndexFieldTypeOptionsStep<?, ?> step) {
        if (this.decimalScale != null) {
            step.decimalScale(this.decimalScale.intValue());
        } else {
            step.decimalScale(0);
        }
    }

    private void bindStringTypeOptions(IndexFieldTypeFactory typeFactory, StringIndexFieldTypeOptionsStep<?> step) {
        this.bindNormalizerOrAnalyzer((LuceneIndexFieldTypeFactoryImpl)typeFactory, step);
        if (this.norms != null) {
            step.norms(this.norms);
        }
        if (this.searchAnalyzer != null) {
            step.searchAnalyzer(this.searchAnalyzer);
        }
        if (this.termVector != null) {
            step.termVector(this.termVector);
        }
    }

    private void bindNormalizerOrAnalyzer(LuceneIndexFieldTypeFactoryImpl typeFactory, StringIndexFieldTypeOptionsStep<?> step) {
        if (this.normalizer != null) {
            step.normalizer(this.normalizer);
            return;
        }
        if (this.analyzer == null) {
            return;
        }
        LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry = typeFactory.getAnalysisDefinitionRegistry();
        if (analysisDefinitionRegistry.getNormalizerDefinition(this.analyzer) != null) {
            step.normalizer(this.analyzer);
        } else {
            step.analyzer(this.analyzer);
        }
    }

    public String toString() {
        return "{name='" + this.name + "', type=" + String.valueOf(this.type) + "}";
    }
}

