/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.server.core.admin.AdminServerTask;

public class CacheCreateTask
extends AdminServerTask<Void> {
    private static final Set<String> PARAMETERS = Set.of("name", "template", "configuration");

    @Override
    public String getTaskContextName() {
        return "cache";
    }

    @Override
    public String getTaskOperationName() {
        return "create";
    }

    public Set<String> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected Void execute(EmbeddedCacheManager cacheManager, Map<String, List<String>> parameters, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        String name = this.requireParameter(parameters, "name");
        String template = this.getParameter(parameters, "template");
        String configuration = this.getParameter(parameters, "configuration");
        if (configuration != null) {
            Configuration config = this.getConfigurationBuilder(name, configuration).build();
            if (!cacheManager.getCacheManagerConfiguration().isClustered() && config.clustering().cacheMode().isClustered()) {
                throw log.cannotCreateClusteredCache();
            }
            ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(flags)).createCache(name, config);
        } else {
            ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(flags)).createCache(name, template);
        }
        return null;
    }

    protected ConfigurationBuilder getConfigurationBuilder(String name, String configuration) {
        ParserRegistry parser = new ParserRegistry();
        ConfigurationBuilderHolder builderHolder = parser.parse(configuration, null);
        Map builders = builderHolder.getNamedConfigurationBuilders();
        if (builders.isEmpty()) {
            throw log.missingCacheConfiguration(name, configuration);
        }
        if (builders.size() > 1) {
            throw log.configurationMustContainSingleCache(name, configuration);
        }
        return (ConfigurationBuilder)builders.values().iterator().next();
    }
}

