/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminServerTask;

public class SchemaCreateOrUpdateTask
extends AdminServerTask<byte[]> {
    private static final String NAME = "name";
    private static final String CONTENT = "content";
    private static final String OP = "op";
    private static final String FORCE = "force";
    private static final String C = "c";
    private static final String U = "u";
    private static final String S = "s";
    private static final String N = "n";
    private static final String F = "f";
    private static final Set<String> PARAMETERS = Set.of("name", "content", "op", "force");

    @Override
    public String getTaskContextName() {
        return "schemas";
    }

    @Override
    public String getTaskOperationName() {
        return "createOrUpdate";
    }

    public Set<String> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected byte[] execute(EmbeddedCacheManager cacheManager, Map<String, List<String>> parameters, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        String schemaName = this.requireParameter(parameters, NAME);
        String schemaContent = this.requireParameter(parameters, CONTENT);
        String op = this.requireParameter(parameters, OP);
        boolean force = F.equals(this.getParameter(parameters, FORCE));
        AdvancedCache schemasCache = cacheManager.getCache("___protobuf_metadata").getAdvancedCache();
        return (switch (op) {
            case C -> this.create((AdvancedCache<String, String>)schemasCache, schemaName, schemaContent);
            case U -> this.update((AdvancedCache<String, String>)schemasCache, schemaName, schemaContent, force);
            case S -> this.save((AdvancedCache<String, String>)schemasCache, schemaName, schemaContent, force);
            default -> "";
        }).getBytes(StandardCharsets.UTF_8);
    }

    private String create(AdvancedCache<String, String> schemas, String schemaName, String schemaContent) {
        String prevValue = (String)schemas.putIfAbsent((Object)schemaName, (Object)schemaContent);
        if (prevValue != null) {
            return N;
        }
        return SchemaCreateOrUpdateTask.appendError(schemas, schemaName, C);
    }

    private String update(AdvancedCache<String, String> schemas, String schemaName, String schemaContent, boolean force) {
        if (force) {
            if (schemas.replace((Object)schemaName, (Object)schemaContent) == null) {
                return N;
            }
            return SchemaCreateOrUpdateTask.appendError(schemas, schemaName, U);
        }
        return this.update(schemas, schemaName, schemaContent, (CacheEntry<String, String>)schemas.getCacheEntry((Object)schemaName));
    }

    private String update(AdvancedCache<String, String> schemas, String schemaName, String schemaContent, CacheEntry<String, String> existingEntry) {
        String result = N;
        if (existingEntry == null) {
            return result;
        }
        String actualSchemaContent = (String)existingEntry.getValue();
        if (!actualSchemaContent.equals(schemaContent) && schemas.replace((Object)schemaName, (Object)actualSchemaContent, (Object)schemaContent)) {
            result = U;
        }
        return SchemaCreateOrUpdateTask.appendError(schemas, schemaName, result);
    }

    private String save(AdvancedCache<String, String> schemas, String schemaName, String schemaContent, boolean force) {
        if (force) {
            String prevValue = (String)schemas.put((Object)schemaName, (Object)schemaContent);
            String result = prevValue == null ? C : U;
            return SchemaCreateOrUpdateTask.appendError(schemas, schemaName, result);
        }
        CacheEntry cacheEntry = schemas.getAdvancedCache().getCacheEntry((Object)schemaName);
        if (cacheEntry == null) {
            return this.create(schemas, schemaName, schemaContent);
        }
        return this.update(schemas, schemaName, schemaContent, (CacheEntry<String, String>)cacheEntry);
    }

    private static String appendError(AdvancedCache<String, String> schemas, String schemaName, String result) {
        String errorKey = schemaName + ".errors";
        String error = (String)schemas.get((Object)errorKey);
        return error == null ? result : result + ";" + error;
    }
}

