/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.parser.ProtostreamProtoParser;
import org.infinispan.server.core.admin.AdminServerTask;

public class SchemaSafeDeleteTask
extends AdminServerTask<byte[]> {
    private static final Set<String> PARAMETERS = Set.of("name");
    private static final byte[] NOT_SAFE_DELETE = "-1".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NOT_EXISTS = "0".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DONE_SAFE_DELETE = "1".getBytes(StandardCharsets.UTF_8);

    @Override
    public String getTaskContextName() {
        return "schemas";
    }

    @Override
    public String getTaskOperationName() {
        return "delete";
    }

    public Set<String> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected byte[] execute(EmbeddedCacheManager cacheManager, Map<String, List<String>> parameters, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        List types;
        String schemaName = this.requireParameter(parameters, "name");
        Cache schemasInternalCache = cacheManager.getCache("___protobuf_metadata");
        String schema = (String)schemasInternalCache.get((Object)schemaName);
        if (schema == null) {
            return NOT_EXISTS;
        }
        try {
            FileDescriptorSource fileDescriptorSource = new FileDescriptorSource().addProtoFile(schemaName, schema);
            ProtostreamProtoParser parser = new ProtostreamProtoParser(org.infinispan.protostream.config.Configuration.builder().build());
            FileDescriptor fileDescriptor = (FileDescriptor)parser.parse(fileDescriptorSource).get(schemaName);
            types = fileDescriptor.getMessageTypes();
        }
        catch (Exception parseError) {
            log.error(parseError);
            types = Collections.emptyList();
        }
        for (Descriptor descriptor : types) {
            String typeName = descriptor.getFullName();
            for (String configName : cacheManager.getCacheConfigurationNames()) {
                Configuration cacheConfiguration = cacheManager.getCacheConfiguration(configName);
                if (!cacheConfiguration.indexing().enabled() || !cacheConfiguration.indexing().indexedEntityTypes().contains(typeName)) continue;
                return NOT_SAFE_DELETE;
            }
        }
        schemasInternalCache.remove((Object)schemaName);
        return DONE_SAFE_DELETE;
    }
}

