/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.document.DateTools;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.query.mapper.mapping.SearchIndexedEntity;
import org.infinispan.query.mapper.mapping.SearchMapping;
import org.infinispan.query.objectfilter.ParsingException;
import org.infinispan.query.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.query.objectfilter.impl.syntax.parser.ProtobufPropertyHelper;
import org.infinispan.query.objectfilter.impl.util.StringHelper;
import org.infinispan.server.core.query.impl.ProtobufFieldIndexingMetadata;
import org.infinispan.server.core.query.impl.indexing.IndexingMetadata;

public final class RemoteHibernateSearchPropertyHelper
extends ProtobufPropertyHelper {
    private static final String KEY = "__ISPN_Key";
    private final SearchMapping searchMapping;

    public static RemoteHibernateSearchPropertyHelper create(SerializationContext serializationContext, SearchMapping searchMapping) {
        RemoteIndexFieldProvider indexedFieldProvider = new RemoteIndexFieldProvider(serializationContext, searchMapping);
        return new RemoteHibernateSearchPropertyHelper(serializationContext, searchMapping, indexedFieldProvider);
    }

    public RemoteHibernateSearchPropertyHelper(SerializationContext serializationContext, SearchMapping searchMapping, IndexedFieldProvider<Descriptor> indexedFieldProvider) {
        super(serializationContext, indexedFieldProvider);
        this.searchMapping = searchMapping;
    }

    public Object convertToPropertyType(Descriptor entityType, String[] propertyPath, String value) {
        IndexValueFieldDescriptor fieldDescriptor = this.getValueFieldDescriptor(entityType, propertyPath);
        if (fieldDescriptor == null) {
            return super.convertToPropertyType(entityType, propertyPath, value);
        }
        Class type = fieldDescriptor.type().dslArgumentClass();
        if (Date.class == type) {
            try {
                return DateTools.stringToDate((String)value);
            }
            catch (ParseException e) {
                throw new ParsingException((Throwable)e);
            }
        }
        return super.convertToPropertyType(entityType, propertyPath, value);
    }

    public Class<?> getPrimitivePropertyType(Descriptor entityType, String[] propertyPath) {
        IndexValueFieldDescriptor fieldDescriptor;
        if (propertyPath.length == 1) {
            if (propertyPath[0].equals("__ISPN_Version")) {
                return EntryVersion.class;
            }
            if (propertyPath[0].equals("__ISPN_Score")) {
                return Float.class;
            }
        }
        if ((fieldDescriptor = this.getValueFieldDescriptor(entityType, propertyPath)) == null) {
            return super.getPrimitivePropertyType(entityType, propertyPath);
        }
        Class type = fieldDescriptor.type().dslArgumentClass();
        if (type.isEnum()) {
            return type;
        }
        return (Class)primitives.get(type);
    }

    public Class<?> getIndexedPropertyType(Descriptor entityType, String[] propertyPath) {
        IndexValueFieldDescriptor fieldDescriptor = this.getValueFieldDescriptor(entityType, propertyPath);
        if (fieldDescriptor == null) {
            return null;
        }
        return fieldDescriptor.type().dslArgumentClass();
    }

    public boolean isNestedIndexStructure(Descriptor entityType, String[] propertyPath) {
        IndexFieldDescriptor fieldDescriptor = this.getFieldDescriptor(entityType, propertyPath);
        return fieldDescriptor != null && fieldDescriptor.type().traits().contains("predicate:nested");
    }

    public boolean isRepeatedProperty(Descriptor entityType, String[] propertyPath) {
        IndexFieldDescriptor fieldDescriptor = this.getFieldDescriptor(entityType, propertyPath);
        if (fieldDescriptor == null) {
            return super.isRepeatedProperty(entityType, propertyPath);
        }
        return fieldDescriptor.multiValuedInRoot();
    }

    public boolean hasEmbeddedProperty(Descriptor entityType, String[] propertyPath) {
        IndexFieldDescriptor fieldDescriptor = this.getFieldDescriptor(entityType, propertyPath);
        if (fieldDescriptor == null) {
            return super.hasEmbeddedProperty(entityType, propertyPath);
        }
        return fieldDescriptor.isObjectField();
    }

    public boolean hasProperty(Descriptor entityType, String[] propertyPath) {
        IndexFieldDescriptor fieldDescriptor = this.getFieldDescriptor(entityType, propertyPath);
        if (fieldDescriptor != null) {
            return true;
        }
        if (propertyPath.length == 1 && (propertyPath[0].equals(KEY) || propertyPath[0].equals("__HSearch_This") || propertyPath[0].equals("__ISPN_Version") || propertyPath[0].equals("__ISPN_Score"))) {
            return true;
        }
        return super.hasProperty(entityType, propertyPath);
    }

    private IndexValueFieldDescriptor getValueFieldDescriptor(Descriptor entityType, String[] propertyPath) {
        IndexFieldDescriptor fieldDescriptor = this.getFieldDescriptor(entityType, propertyPath);
        if (fieldDescriptor == null) {
            return null;
        }
        return fieldDescriptor.isObjectField() ? null : fieldDescriptor.toValueField();
    }

    private IndexFieldDescriptor getFieldDescriptor(Descriptor entityType, String[] propertyPath) {
        IndexDescriptor indexDescriptor = this.getIndexDescriptor(entityType);
        if (indexDescriptor == null) {
            return null;
        }
        Optional field = indexDescriptor.field(StringHelper.join((String[])propertyPath));
        return field.orElse(null);
    }

    private IndexDescriptor getIndexDescriptor(Descriptor type) {
        if (this.searchMapping == null) {
            return null;
        }
        SearchIndexedEntity indexedEntity = this.searchMapping.indexedEntity(type.getFullName());
        if (indexedEntity == null) {
            return null;
        }
        return indexedEntity.indexManager().descriptor();
    }

    public static class RemoteIndexFieldProvider
    implements IndexedFieldProvider<Descriptor> {
        private final SerializationContext serializationContext;
        private final SearchMapping searchMapping;

        public RemoteIndexFieldProvider(SerializationContext serializationContext, SearchMapping searchMapping) {
            this.serializationContext = serializationContext;
            this.searchMapping = searchMapping;
        }

        public IndexedFieldProvider.FieldIndexingMetadata<Descriptor> get(Descriptor messageDescriptor) {
            if (this.searchMapping == null) {
                return new ProtobufFieldIndexingMetadata(messageDescriptor, this.serializationContext.getGenericDescriptors());
            }
            SearchIndexedEntity indexedEntity = this.searchMapping.indexedEntity(messageDescriptor.getFullName());
            if (indexedEntity == null) {
                return new ProtobufFieldIndexingMetadata(messageDescriptor, this.serializationContext.getGenericDescriptors());
            }
            IndexDescriptor descriptor = indexedEntity.indexManager().descriptor();
            return new SearchFieldIndexingMetadata(descriptor, messageDescriptor, this.serializationContext.getGenericDescriptors());
        }
    }

    public static final class SearchFieldIndexingMetadata
    implements IndexedFieldProvider.FieldIndexingMetadata<Descriptor> {
        private final Descriptor messageDescriptor;
        private final IndexDescriptor indexDescriptor;
        private final String keyProperty;
        private final Descriptor keyMessageDescriptor;

        public SearchFieldIndexingMetadata(IndexDescriptor indexDescriptor, Descriptor messageDescriptor, Map<String, GenericDescriptor> genericDescriptors) {
            if (messageDescriptor == null) {
                throw new IllegalArgumentException("argument cannot be null");
            }
            this.indexDescriptor = indexDescriptor;
            this.messageDescriptor = messageDescriptor;
            IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(messageDescriptor, "Indexed");
            if (indexingMetadata != null && indexingMetadata.indexingKey() != null) {
                this.keyProperty = indexingMetadata.indexingKey().fieldName();
                this.keyMessageDescriptor = (Descriptor)genericDescriptors.get(indexingMetadata.indexingKey().typeFullName());
            } else {
                this.keyProperty = null;
                this.keyMessageDescriptor = null;
            }
        }

        public boolean hasProperty(String[] propertyPath) {
            return this.getField(propertyPath) != null;
        }

        public boolean isSearchable(String[] propertyPath) {
            IndexValueFieldTypeDescriptor field = this.getField(propertyPath);
            return field != null && field.searchable();
        }

        public boolean isAnalyzed(String[] propertyPath) {
            IndexValueFieldTypeDescriptor field = this.getField(propertyPath);
            return field != null && field.analyzerName().isPresent();
        }

        public boolean isNormalized(String[] propertyPath) {
            IndexValueFieldTypeDescriptor field = this.getField(propertyPath);
            return field != null && field.normalizerName().isPresent();
        }

        public boolean isProjectable(String[] propertyPath) {
            IndexValueFieldTypeDescriptor field = this.getField(propertyPath);
            return field != null && field.projectable();
        }

        public boolean isAggregable(String[] propertyPath) {
            IndexValueFieldTypeDescriptor field = this.getField(propertyPath);
            return field != null && field.aggregable();
        }

        public boolean isSortable(String[] propertyPath) {
            IndexValueFieldTypeDescriptor field = this.getField(propertyPath);
            return field != null && field.sortable();
        }

        public boolean isVector(String[] propertyPath) {
            IndexValueFieldTypeDescriptor field = this.getField(propertyPath);
            return field != null && field.traits().contains("predicate:knn");
        }

        public Object getNullMarker(String[] propertyPath) {
            Descriptor md = this.messageDescriptor;
            int i = 0;
            for (String p : propertyPath) {
                ++i;
                FieldDescriptor field = md.findFieldByName(p);
                if (field == null) break;
                if (i == propertyPath.length) {
                    IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(md, "Indexed");
                    return indexingMetadata == null ? null : indexingMetadata.getNullMarker(field.getName());
                }
                if (field.getJavaType() != JavaType.MESSAGE) break;
                md = field.getMessageType();
            }
            return null;
        }

        public Descriptor keyType(String property) {
            return property.equals(this.keyProperty) ? this.keyMessageDescriptor : null;
        }

        public boolean isSpatial(String[] propertyPath) {
            IndexValueFieldTypeDescriptor field = this.getField(propertyPath);
            if (field == null) {
                return false;
            }
            Set traits = field.traits();
            return traits.contains("predicate:spatial:within-bounding-box") || traits.contains("predicate:spatial:within-circle") || traits.contains("predicate:spatial:within-polygon");
        }

        private IndexValueFieldTypeDescriptor getField(String[] propertyPath) {
            Optional field = this.indexDescriptor.field(StringHelper.join((String[])propertyPath));
            if (!field.isPresent()) {
                return null;
            }
            IndexFieldDescriptor indexFieldDescriptor = (IndexFieldDescriptor)field.get();
            if (!indexFieldDescriptor.isValueField()) {
                return null;
            }
            return indexFieldDescriptor.toValueField().type();
        }
    }
}

