/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.mapper.mapping.SearchMapping;
import org.infinispan.query.objectfilter.Matcher;
import org.infinispan.query.objectfilter.impl.ProtobufMatcher;
import org.infinispan.server.core.query.impl.BaseRemoteQueryManager;
import org.infinispan.server.core.query.impl.ObjectProtobufMatcher;
import org.infinispan.server.core.query.impl.ProtobufWrapper;
import org.infinispan.server.core.query.impl.QuerySerializers;
import org.infinispan.server.core.query.impl.RemoteHibernateSearchPropertyHelper;
import org.infinispan.server.core.query.impl.RemoteQueryEngine;

public final class ProtobufRemoteQueryManager
extends BaseRemoteQueryManager {
    private final RemoteQueryEngine queryEngine;
    private final Transcoder protobufTranscoder;

    public ProtobufRemoteQueryManager(AdvancedCache<?, ?> cache, ComponentRegistry cr, SerializationContext serCtx, QuerySerializers querySerializers, SearchMapping searchMapping) {
        super(cache, querySerializers, cr);
        RemoteHibernateSearchPropertyHelper propertyHelper = RemoteHibernateSearchPropertyHelper.create(serCtx, searchMapping);
        ObjectProtobufMatcher matcher = new ObjectProtobufMatcher(serCtx, propertyHelper);
        cr.registerComponent((Object)matcher, ProtobufMatcher.class);
        Configuration configuration = cache.getCacheConfiguration();
        boolean isIndexed = configuration.indexing().enabled();
        boolean customStorage = configuration.encoding().valueDataType().isMediaTypeChanged();
        MediaType valueMediaType = this.getValueDataConversion().getStorageMediaType();
        boolean isProtoBuf = valueMediaType.match(MediaType.APPLICATION_PROTOSTREAM);
        if (isProtoBuf || !customStorage && isIndexed) {
            StorageConfigurationManager storageConfigurationManager = (StorageConfigurationManager)cr.getComponent(StorageConfigurationManager.class);
            storageConfigurationManager.overrideWrapper(storageConfigurationManager.getKeyWrapper(), (Wrapper)ProtobufWrapper.INSTANCE);
        }
        this.queryEngine = new RemoteQueryEngine(cache, isIndexed);
        EncoderRegistry encoderRegistry = (EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        this.protobufTranscoder = encoderRegistry.getTranscoder(MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OBJECT);
    }

    @Override
    public Class<? extends Matcher> getMatcherClass(MediaType mediaType) {
        return ProtobufMatcher.class;
    }

    @Override
    public RemoteQueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        return this.queryEngine;
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        return this.protobufTranscoder.transcode(filterResult, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM);
    }
}

