/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.iteration.list;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;

public class ListStreamSupplier
implements AbstractLocalCacheStream.StreamSupplier<CacheEntry<Object, Object>, Stream<CacheEntry<Object, Object>>> {
    private final List<Map.Entry<Object, Object>> source;

    public ListStreamSupplier(List<Map.Entry<Object, Object>> source) {
        this.source = source;
    }

    public Stream<CacheEntry<Object, Object>> buildStream(IntSet ignore, Set valuesToFilter, boolean parallel) {
        if (this.source == null) {
            return Stream.empty();
        }
        Stream stream = parallel ? this.source.parallelStream() : this.source.stream();
        return stream.map(this::convert);
    }

    private CacheEntry<Object, Object> convert(Map.Entry<Object, Object> entry) {
        return new ImmortalCacheEntry(entry.getKey(), entry.getValue());
    }
}

