/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import java.io.Serializable;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.core.impl.eventfilter.IckleFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.objectfilter.impl.ProtobufMatcher;
import org.infinispan.query.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.server.core.query.impl.ObjectRemoteQueryEngine;
import org.infinispan.server.core.query.impl.RemoteQueryManager;
import org.infinispan.server.core.query.impl.filter.IckleProtobufFilterAndConverter;
import org.infinispan.server.core.query.impl.indexing.IndexingMetadata;
import org.infinispan.server.core.query.impl.mapping.type.ProtobufKeyValuePair;
import org.infinispan.util.function.SerializableFunction;

final class RemoteQueryEngine
extends ObjectRemoteQueryEngine {
    private static final SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider = (SerializableFunction & Serializable)c -> ((RemoteQueryManager)ComponentRegistry.componentOf((Cache)c, RemoteQueryManager.class)).getQueryEngine((AdvancedCache<?, ?>)c);

    RemoteQueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed) {
        super(cache.withStorageMediaType(), isIndexed, ProtobufMatcher.class);
    }

    protected QueryEngine.RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes, Object[] projectedNullMarkers) {
        if (projectedNullMarkers != null) {
            for (Object projectedNullMarker : projectedNullMarkers) {
                if (projectedNullMarker == null) continue;
                return row -> {
                    for (int i = 0; i < projectedNullMarkers.length; ++i) {
                        if (row[i] == null || !row[i].equals(projectedNullMarkers[i])) continue;
                        row[i] = null;
                    }
                    return row;
                };
            }
        }
        return null;
    }

    protected SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> getQueryEngineProvider() {
        return queryEngineProvider;
    }

    protected IckleFilterAndConverter createFilter(String queryString, Map<String, Object> namedParameters) {
        return this.isIndexed ? new IckleProtobufFilterAndConverter(queryString, namedParameters) : super.createFilter(queryString, namedParameters);
    }

    protected Class<?> getTargetedClass(IckleParsingResult<?> parsingResult) {
        Descriptor metadata = (Descriptor)parsingResult.getTargetEntityMetadata();
        IndexingMetadata indexingMetadata = (IndexingMetadata)metadata.getProcessedAnnotation("Indexed");
        if (indexingMetadata == null) {
            return byte[].class;
        }
        return indexingMetadata.indexingKey() == null ? byte[].class : ProtobufKeyValuePair.class;
    }

    protected String getTargetedNamedType(IckleParsingResult<?> parsingResult) {
        Descriptor targetEntityMetadata = (Descriptor)parsingResult.getTargetEntityMetadata();
        return targetEntityMetadata.getFullName();
    }
}

