/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl.access;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.api.query.ClosableIteratorWithCount;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.server.core.query.impl.RemoteQueryAccessEngine;

public class RemoteQueryAccessQuery<T>
implements Query<T> {
    private final RemoteQueryAccessEngine engine;
    private final String queryString;
    private Map<String, Object> namedParametersMap = new HashMap<String, Object>();
    private int offset = 0;
    private int maxResults;
    private int hitCountAccuracy;
    public boolean local = false;

    public RemoteQueryAccessQuery(RemoteQueryAccessEngine engine, String queryString) {
        this.engine = engine;
        this.queryString = queryString;
        this.maxResults = engine.defaultMaxResult();
        this.hitCountAccuracy = engine.defaultHitCountAccuracy();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List<T> list() {
        return this.execute().list();
    }

    public QueryResult<T> execute() {
        return this.engine.executeQuery(this.queryString, this.namedParametersMap, this.offset, this.maxResults, this.hitCountAccuracy, this.local);
    }

    public CompletionStage<QueryResult<T>> executeAsync() {
        throw new UnsupportedOperationException();
    }

    public int executeStatement() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    public CompletionStage<Integer> executeStatementAsync() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    public boolean hasProjections() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    public long getStartOffset() {
        return this.offset;
    }

    public Query<T> startOffset(long startOffset) {
        this.offset = (int)startOffset;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Query<T> maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public Integer hitCountAccuracy() {
        return this.hitCountAccuracy;
    }

    public Query<T> hitCountAccuracy(int hitCountAccuracy) {
        this.hitCountAccuracy = hitCountAccuracy;
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.namedParametersMap;
    }

    public Query<T> setParameter(String paramName, Object paramValue) {
        this.namedParametersMap.put(paramName, paramValue);
        return this;
    }

    public Query<T> setParameters(Map<String, Object> paramValues) {
        this.namedParametersMap = paramValues;
        return this;
    }

    public CloseableIterator<T> iterator() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    public <K> ClosableIteratorWithCount<EntityEntry<K, T>> entryIterator(boolean withMetadata) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    public Query<T> timeout(long timeout, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    public Query<T> local(boolean local) {
        this.local = local;
        return this;
    }

    public Query<T> scoreRequired(boolean scoreRequired) {
        throw new UnsupportedOperationException("Not implemented!");
    }
}

