/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security.sasl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.infinispan.server.core.security.sasl.AuthorizingCallbackHandler;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;

public class SubjectSaslServer
implements SaslServer {
    public static final String SUBJECT = "org.infinispan.security.Subject";
    protected final SaslServer delegate;
    protected final AuthorizingCallbackHandler callbackHandler;
    protected final List<Principal> principals;

    public SubjectSaslServer(SaslServer delegate, List<Principal> principals, AuthorizingCallbackHandler callbackHandler) {
        this.delegate = delegate;
        this.principals = principals;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return this.delegate.getMechanismName();
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.delegate.evaluateResponse(response);
    }

    @Override
    public boolean isComplete() {
        return this.delegate.isComplete();
    }

    @Override
    public String getAuthorizationID() {
        return this.delegate.getAuthorizationID();
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return this.delegate.unwrap(incoming, offset, len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return this.delegate.wrap(outgoing, offset, len);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (SUBJECT.equals(propName)) {
            if (this.isComplete()) {
                SimpleUserPrincipal userPrincipal = new SimpleUserPrincipal(SubjectSaslServer.normalizeAuthorizationId(this.getAuthorizationID()));
                ArrayList<Principal> combinedPrincipals = new ArrayList<Principal>(this.principals.size() + 1);
                combinedPrincipals.add(userPrincipal);
                combinedPrincipals.addAll(this.principals);
                return this.callbackHandler.getSubjectUserInfo(combinedPrincipals).getSubject();
            }
            throw new IllegalStateException("Authentication is not complete");
        }
        return this.delegate.getNegotiatedProperty(propName);
    }

    @Override
    public void dispose() throws SaslException {
        this.delegate.dispose();
    }

    private static String normalizeAuthorizationId(String id) {
        int realm = id.indexOf(64);
        if (realm >= 0) {
            return id.substring(0, realm);
        }
        return id;
    }
}

