package org.infinispan.server.core.transport;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.processing.Generated;

import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.MBeanMetadata.AttributeMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationParameterMetadata;
import org.infinispan.factories.impl.Scopes;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.lifecycle.ModuleLifecycle;

/**
 * @api.private 
 */
@Generated(value = "org.infinispan.component.processor.Generator")
public final class ServerCorePackageImpl {
   public static void registerMetadata(ModuleMetadataBuilder.ModuleBuilder builder) {
//start org.infinispan.server.core.transport.NettyTransport
      builder.registerComponentAccessor("org.infinispan.server.core.transport.NettyTransport",
         Collections.emptyList(),
         new ComponentAccessor<NettyTransport>("org.infinispan.server.core.transport.NettyTransport",
            3, false, null,
            Collections.emptyList()));

      builder.registerMBeanMetadata("org.infinispan.server.core.transport.NettyTransport",
         MBeanMetadata.of("Transport", "Transport component manages read and write operations to/from server.", null, Scopes.SERVER,
            new AttributeMetadata("hostName", "Returns the host to which the transport binds.", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("idleTimeout", "Returns the idle timeout.", false, true, "int", false, null, null, false),
            new AttributeMetadata("numberIOThreads", "Returns the number of I/O threads.", false, true, "int", false, (java.util.function.Function<org.infinispan.server.core.transport.NettyTransport, ?>) org.infinispan.server.core.transport.NettyTransport::getNumberIOThreads, null, false),
            new AttributeMetadata("numberOfGlobalConnections", "Returns a count of active connections in the cluster. This operation will make remote calls to aggregate results, so latency might have an impact on the speed of calculation of this attribute.", false, true, "int", false, (java.util.function.Function<org.infinispan.server.core.transport.NettyTransport, ?>) org.infinispan.server.core.transport.NettyTransport::getNumberOfGlobalConnections, null, true),
            new AttributeMetadata("numberOfLocalConnections", "Returns a count of active connections this server.", false, true, "int", false, (java.util.function.Function<org.infinispan.server.core.transport.NettyTransport, ?>) org.infinispan.server.core.transport.NettyTransport::getNumberOfLocalConnections, null, false),
            new AttributeMetadata("pendingTasks", "Returns the number of pending tasks.", false, true, "int", false, (java.util.function.Function<org.infinispan.server.core.transport.NettyTransport, ?>) org.infinispan.server.core.transport.NettyTransport::getPendingTasks, null, false),
            new AttributeMetadata("port", "Returns the port to which the transport binds.", false, true, "int", false, null, null, false),
            new AttributeMetadata("receiveBufferSize", "Returns the receive buffer size.", false, true, "int", false, null, null, false),
            new AttributeMetadata("running", "Returns whether the transport is running", false, true, "boolean", true, null, null, false),
            new AttributeMetadata("sendBufferSize", "Returns the send buffer size.", false, true, "int", false, null, null, false),
            new AttributeMetadata("tcpNoDelay", "Returns whether TCP no delay was configured or not.", false, true, "boolean", false, null, null, false),
            new AttributeMetadata("totalBytesRead", "Returns the total number of bytes read by the server from clients which includes both protocol and user information.", false, true, "long", false, (java.util.function.Function<org.infinispan.server.core.transport.NettyTransport, ?>) org.infinispan.server.core.transport.NettyTransport::getTotalBytesRead, null, false),
            new AttributeMetadata("totalBytesWritten", "Returns the total number of bytes written by the server back to clients which includes both protocol and user information.", false, true, "long", false, (java.util.function.Function<org.infinispan.server.core.transport.NettyTransport, ?>) org.infinispan.server.core.transport.NettyTransport::getTotalBytesWritten, null, false),
            new OperationMetadata("start", "start", "Starts the transport", "void"
            ),
            new OperationMetadata("stop", "stop", "Stops the transport", "void"
            )
      ));

//start org.infinispan.server.core.transport.NonRecursiveEventLoopGroup
      builder.registerComponentAccessor("org.infinispan.server.core.transport.NonRecursiveEventLoopGroup",
         Collections.emptyList(),
         new ComponentAccessor<NonRecursiveEventLoopGroup>("org.infinispan.server.core.transport.NonRecursiveEventLoopGroup",
            0, false, null,
            Collections.emptyList()) {
         protected void stop(NonRecursiveEventLoopGroup instance) throws Exception {
            instance.shutdownGracefullyAndWait();
         }

      });

//end
   }
}
