/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.SaslAuthenticationConfiguration;
import org.infinispan.server.core.configuration.SaslConfigurationBuilder;

public class SaslAuthenticationConfigurationBuilder
implements AuthenticationConfigurationBuilder<SaslAuthenticationConfiguration> {
    private final AttributeSet attributes;
    private boolean enabled = false;
    private final SaslConfigurationBuilder sasl = new SaslConfigurationBuilder();

    public SaslAuthenticationConfigurationBuilder(ProtocolServerConfigurationChildBuilder<?, ?, ?> builder) {
        this.attributes = SaslAuthenticationConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SaslAuthenticationConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public SaslAuthenticationConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public SaslAuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public SaslAuthenticationConfigurationBuilder securityRealm(String name) {
        this.attributes.attribute(SaslAuthenticationConfiguration.SECURITY_REALM).set((Object)name);
        return this;
    }

    @Override
    public String securityRealm() {
        return (String)this.attributes.attribute(SaslAuthenticationConfiguration.SECURITY_REALM).get();
    }

    public boolean hasSecurityRealm() {
        return !this.attributes.attribute(SaslAuthenticationConfiguration.SECURITY_REALM).isNull();
    }

    public SaslConfigurationBuilder sasl() {
        return this.sasl;
    }

    public void validate() {
        if (this.enabled) {
            this.sasl.validate();
        }
    }

    public SaslAuthenticationConfiguration create() {
        return new SaslAuthenticationConfiguration(this.attributes.protect(), this.sasl.create(), this.enabled);
    }

    public Builder<?> read(SaslAuthenticationConfiguration template, Combine combine) {
        this.enabled = template.enabled();
        this.sasl.read(template.sasl(), combine);
        return this;
    }
}

