/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.util.Arrays;
import org.infinispan.server.core.utils.SslUtils;
import reactor.blockhound.BlockHound;
import reactor.blockhound.BlockingOperationError;
import reactor.blockhound.integration.BlockHoundIntegration;

public class ServerCoreBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside("com.sun.org.apache.xerces.internal.util.DefaultErrorHandler", "printError");
        builder.allowBlockingCallsInside("com.thoughtworks.xstream.converters.reflection.SerializableConverter", "isSerializable");
        builder.allowBlockingCallsInside("jdk.nashorn.api.scripting.NashornScriptEngineFactory", "getScriptEngine");
        ServerCoreBlockHoundIntegration.questionableBlockingMethod(builder);
        ServerCoreBlockHoundIntegration.methodsToBeRemoved(builder);
        ServerCoreBlockHoundIntegration.configureBlockingCallback(builder);
    }

    private static void configureBlockingCallback(BlockHound.Builder builder) {
        builder.blockingMethodCallback(bm -> {
            BlockingOperationError error = new BlockingOperationError(bm);
            StackTraceElement[] stackTrace = error.getStackTrace();
            int length = stackTrace.length;
            for (int i = 0; i < length; ++i) {
                StackTraceElement stackTraceElement = stackTrace[i];
                if (!"checkBlocking".equals(stackTraceElement.getMethodName())) continue;
                if (i + 1 >= length) break;
                error.setStackTrace(Arrays.copyOfRange(stackTrace, i + 1, length));
                break;
            }
            error.printStackTrace();
            throw error;
        });
    }

    private static void questionableBlockingMethod(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside(SslUtils.class.getName(), "createNettySslContext");
    }

    private static void methodsToBeRemoved(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside("org.infinispan.counter.impl.manager.EmbeddedCounterManager", "createCounter");
    }
}

