/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.infinispan.commons.util.Util;

public class ExtendedByteBufJava {
    private ExtendedByteBufJava() {
    }

    public static long readUnsignedMaybeLong(ByteBuf buf) {
        if (buf.readableBytes() < 8) {
            buf.resetReaderIndex();
            return Long.MIN_VALUE;
        }
        return buf.readLong();
    }

    public static long readMaybeVLong(ByteBuf buf) {
        if (buf.readableBytes() > 0) {
            byte b = buf.readByte();
            long i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (buf.readableBytes() == 0) {
                    buf.resetReaderIndex();
                    return Long.MIN_VALUE;
                }
                b = buf.readByte();
                i |= ((long)b & 0x7FL) << shift;
                shift += 7;
            }
            return i;
        }
        buf.resetReaderIndex();
        return Long.MIN_VALUE;
    }

    public static int readMaybeVInt(ByteBuf buf) {
        int i = 0;
        int shift = 0;
        while (buf.isReadable()) {
            byte b = buf.readByte();
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            if ((b & 0x80) == 0) {
                return i;
            }
            shift += 7;
        }
        buf.resetReaderIndex();
        return Integer.MIN_VALUE;
    }

    public static String readString(ByteBuf bf) {
        int length = ExtendedByteBufJava.readMaybeVInt(bf);
        if (length == Integer.MIN_VALUE) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        if (!bf.isReadable(length)) {
            bf.resetReaderIndex();
            return null;
        }
        int startIndex = bf.readerIndex();
        bf.skipBytes(length);
        return bf.toString(startIndex, length, StandardCharsets.UTF_8);
    }

    public static byte[] readMaybeRangedBytes(ByteBuf bf) {
        int length = ExtendedByteBufJava.readMaybeVInt(bf);
        if (length == Integer.MIN_VALUE) {
            return null;
        }
        return ExtendedByteBufJava.readMaybeRangedBytes(bf, length);
    }

    public static byte[] readMaybeRangedBytes(ByteBuf bf, int length) {
        if (!bf.isReadable(length)) {
            bf.resetReaderIndex();
            return null;
        }
        if (length == 0) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        bf.readBytes(bytes);
        return bytes;
    }
}

